% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{partgam_DIF}
\alias{partgam_DIF}
\title{Partial Gamma to detect Differential Item Functioning (DIF)}
\usage{
partgam_DIF(dat.items, dat.exo, p.adj = c("BH", "holm", "hochberg",
  "hommel", "bonferroni", "BY", "none"))
}
\arguments{
\item{dat.items}{A data frame with the responses to the items.}

\item{dat.exo}{A single grouping factor or a data frame consisting of several exogenous factor variables.}

\item{p.adj}{Correction method for multiple testing. The methods are "BH","holm", "hochberg", "hommel", "bonferroni", "BY", "none". See \code{\link{p.adjust}}.}
}
\value{
data frame with Gamma coefficients, standard errors, p values, adjusted p values if an adjustment method has be chosen,  and confidence limits for every
pair of an item and an exogenous variable.
}
\description{
Items should function in the same way for all subgroups of persons. An item
shows differential item functioning (DIF) if there is a significant association between the item score and
an exogenous variable, controlling for the scale score. Partial Gamma coefficients are used as test statistics.
}
\examples{
partgam_DIF(amts[,4:13],amts[,2:3])
}
\references{
Bjorner, J., Kreiner, S., Ware, J., Damsgaard, M. and Bech, P. Differential item
functioning in the Danish translation of the SF-36. \emph{Journal of Clinical Epidemiology},
51 (11), 1998, pp. 1189-1202.
}
\seealso{
{\code{\link{partgam_LD}}}
}
\author{
Marianne Mueller
}
