% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_py_install.R
\name{ifcb_py_install}
\alias{ifcb_py_install}
\title{Install iRfcb Python Environment}
\usage{
ifcb_py_install(
  envname = ".virtualenvs/iRfcb",
  use_venv = TRUE,
  packages = NULL
)
}
\arguments{
\item{envname}{A character string specifying the name of the virtual environment to create. Default is ".virtualenvs/iRfcb".}

\item{use_venv}{Logical. If \code{TRUE} (default), a virtual environment is created. If \code{FALSE}, the system Python is used instead, and missing packages are installed globally for the user.}

\item{packages}{A character vector of additional Python packages to install. If NULL (default), only the packages from "requirements.txt" are installed.}
}
\value{
No return value. This function is called for its side effect of configuring the Python environment.
}
\description{
This function sets up the Python environment for \code{iRfcb}. By default, it creates and activates a Python virtual environment (\code{venv}) named "iRfcb" and installs the required Python packages from the "requirements.txt" file.
Alternatively, users can opt to use the system Python instead of creating a virtual environment by setting \code{use_venv = FALSE}.
}
\examples{
\dontrun{
# Install the iRfcb Python environment using a virtual environment (default)
ifcb_py_install()

# Install the iRfcb Python environment with additional packages
ifcb_py_install(packages = c("numpy", "plotly"))

# Use system Python instead of a virtual environment
ifcb_py_install(use_venv = FALSE)
}
}
