% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstIndex.R
\name{ChaoRichness}
\alias{ChaoRichness}
\title{Estimation of species richness}
\usage{
ChaoRichness(x, datatype = "abundance", conf = 0.95)
}
\arguments{
\item{x}{a \code{matrix}, \code{data.frame} (species by sites), or \code{list} of species abundances or incidence frequencies. If \code{datatype = "incidence_freq"}, 
then the first entry of the input data must be total number of sampling units, followed by species incidence frequencies.}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}),
sampling-unit-based incidence frequencies data (\code{datatype = "incidence_freq"}) or species by sampling-units incidence matrix (\code{datatype = "incidence_raw"}).}

\item{conf}{a positive number \eqn{\le} 1 specifying the level of confidence interval.}
}
\value{
A data.frame of observed species richness, species richness estimate, s.e. and the associated confidence interval.
}
\description{
\code{ChaoRichness}: estimation of species richness based on the methods proposed in Chao (1984, 1987)
}
\examples{
data(spider)
ChaoRichness(spider$Girdled, datatype="abundance")
}
\references{
Chao, A. (1984) Nonparametric estimation of the number of classes in a population. Scandinavian Journal of Statistics, 11, 265-270.\cr\cr
Chao, A. (1987) Estimating the population size for capture-recapture data with unequal catchability. Biometrics, 43, 783-791.
}
\seealso{
\code{\link{ChaoShannon}, \link{ChaoSimpson}}
}
