% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metrics.R
\name{search_metrics}
\alias{search_metrics}
\title{Searches the icite database for entries that match the entered criteria}
\usage{
search_metrics(year = NA, offset = NA, limit = NA, page = FALSE)
}
\arguments{
\item{year}{character or numeric. The year whose data you would like}

\item{offset}{character. The minimum PMID you would like to have
returned}

\item{limit}{character. The maximum number of records you would
like returned. There is a maximum of 1000 for a single call.}

\item{page}{logical. Do you want to continue paging through the API until
there is no new data returned (paging without a limit may take several
hours to complete)?}
}
\value{
All values from the icite_api reformatted into a dataframe. See
  \url{https://icite.od.nih.gov/api} for details.
}
\description{
\code{search metrics} takes a set of search criteria and returns a dataframe
of the information yielded by the iCite API.
}
\examples{
search_metrics(year=2012, offset='1800000', limit='2000', page=TRUE)
}
