% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F039.prep.vdj.R
\name{prep.vdj}
\alias{prep.vdj}
\title{Prepare VDJ data}
\usage{
prep.vdj(vdj.data = "data.frame", cond.name = "NULL")
}
\arguments{
\item{vdj.data}{A data frame containing vdj information.}

\item{cond.name}{Conditions.}
}
\value{
An object of class iCellR
}
\description{
This function takes a data frame of VDJ data per cell and prepares it to adds it to the iCellR object.
}
\examples{
my.vdj <- read.csv(file = system.file('extdata', 'all_contig_annotations.csv',
          package = 'iCellR'),
          as.is = TRUE)
head(my.vdj)
dim(my.vdj)

My.VDJ <- prep.vdj(vdj.data = my.vdj, cond.name = "NULL")
head(My.VDJ)
dim(My.VDJ)

}
