% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F020.cluster.plot.R
\name{cluster.plot}
\alias{cluster.plot}
\title{Plot nGenes, UMIs and perecent mito}
\usage{
cluster.plot(
  x = NULL,
  cell.size = 1,
  plot.type = "tsne",
  cell.color = "black",
  back.col = "white",
  col.by = "clusters",
  cond.facet = FALSE,
  cond.shape = FALSE,
  cell.transparency = 0.5,
  clust.dim = 2,
  angle = 20,
  clonotype.max = 10,
  density = FALSE,
  interactive = TRUE,
  static3D = FALSE,
  out.name = "plot"
)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{cell.size}{A numeric value for the size of the cells, default = 1.}

\item{plot.type}{Choose between "tsne", "pca", "umap", "diffusion", "pseudo.A" and "pseudo.B", default = "tsne".}

\item{cell.color}{Choose cell color if col.by = "monochrome", default = "black".}

\item{back.col}{Choose background color, default = "black".}

\item{col.by}{Choose between "clusters", "conditions", "cc" (cell cycle) or "monochrome", default = "clusters".}

\item{cond.facet}{Show the conditions in separate plots.}

\item{cond.shape}{If TRUE the conditions will be shown in shapes.}

\item{cell.transparency}{A numeric value between 0 to 1, default = 0.5.}

\item{clust.dim}{A numeric value for plot dimensions. Choose either 2 or 3, default = 2.}

\item{angle}{A number to rotate the non-interactive 3D plot.}

\item{clonotype.max}{Number of clonotype to plot, default = 10.}

\item{density}{If TRUE the density plots for PCA/tSNE second dimension will be created, default = FALSE.}

\item{interactive}{If TRUE an html interactive file will be made, default = TRUE.}

\item{static3D}{If TRUE a non-interactive 3D plot will be made.}

\item{out.name}{Output name for html file if interactive = TRUE, default = "plot".}
}
\value{
An object of class iCellR.
}
\description{
This function takes an object of class iCellR and creates plots to see the clusters.
}
\examples{
cluster.plot(demo.obj,plot.type = "umap",interactive = FALSE)

cluster.plot(demo.obj,plot.type = "tsne",interactive = FALSE)

cluster.plot(demo.obj,plot.type = "pca",interactive = FALSE)

cluster.plot(demo.obj,plot.type = "pca",col.by = "conditions",interactive = FALSE)

cluster.plot(demo.obj,plot.type = "umap",col.by = "conditions",interactive = FALSE)

cluster.plot(demo.obj,plot.type = "tsne",col.by = "conditions",interactive = FALSE)
}
