% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F015.run.clustering.R
\name{run.clustering}
\alias{run.clustering}
\title{Clustering the data}
\usage{
run.clustering(x = NULL, clust.method = "kmeans",
  dist.method = "euclidean", index.method = "silhouette",
  max.clust = 25, min.clust = 2, dims = 1:10)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{clust.method}{the cluster analysis method to be used. This should be one of: "ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median", "centroid", "kmeans".}

\item{dist.method}{the distance measure to be used to compute the dissimilarity matrix. This must be one of: "euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski" or "NULL". By default, distance="euclidean". If the distance is "NULL", the dissimilarity matrix (diss) should be given by the user. If distance is not "NULL", the dissimilarity matrix should be "NULL".}

\item{index.method}{the index to be calculated. This should be one of : "kl", "ch", "hartigan", "ccc", "scott", "marriot", "trcovw", "tracew", "friedman", "rubin", "cindex", "db", "silhouette", "duda", "pseudot2", "beale", "ratkowsky", "ball", "ptbiserial", "gap", "frey", "mcclain", "gamma", "gplus", "tau", "dunn", "hubert", "sdindex", "dindex", "sdbw", "all" (all indices except GAP, Gamma, Gplus and Tau), "alllong" (all indices with Gap, Gamma, Gplus and Tau included).}

\item{max.clust}{maximal number of clusters, between 2 and (number of objects - 1), greater or equal to min.nc.}

\item{min.clust}{minimum number of clusters, default = 2.}

\item{dims}{PCA dimentions to be use for clustering, default = 1:10.}
}
\value{
An object of class iCellR.
}
\description{
This function takes an object of class iCellR and finds optimal number of clusters and clusters the data.
}
\examples{
demo.obj <- run.clustering(demo.obj,
                          clust.method = "kmeans",
                          dist.method = "euclidean",
                          index.method = "silhouette",
                          max.clust = 2,
                          min.clust = 2,
                          dims = 1:10)

 head(demo.obj@best.clust)

}
