% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{CiARfit}
\alias{CiARfit}
\title{Fitted Values of CiAR model}
\usage{
CiARfit(coef, series, times, zero_mean = TRUE, standardized = TRUE, c = 1)
}
\arguments{
\item{coef}{An array with the parameters of the CiAR model. The elements of the array are, in order, the real and the imaginary part of the phi parameter of the CiAR model.}

\item{series}{Array with the time series observations.}

\item{times}{Array with the irregular observational times.}

\item{zero_mean}{logical; if TRUE, the array series has zero mean; if FALSE, series has a mean different from zero.}

\item{standardized}{logical; if TRUE, the array series is standardized; if FALSE, series contains the raw time series}

\item{c}{Nuisance parameter corresponding to the variance of the imaginary part.}
}
\value{
A list with the following components:
\item{fitted}{ Fitted values of the observable part of CiAR model.}
\item{xhat}{ Fitted values of both observable part and imaginary part of CiAR model.}
\item{Lambda}{ Lambda value estimated by the CiAR model at the last time point.}
\item{Theta}{ Theta array estimated by the CiAR model at the last time point.}
\item{Sighat}{ Covariance matrix estimated by the CiAR model at the last time point.}
\item{Qt}{ Covariance matrix of the state equation estimated by the CiAR model at the last time point.}
}
\description{
Fit a CiAR model to an irregularly observed time series.
}
\examples{
\dontshow{
n=100
set.seed(6714)
}
}
\references{
\insertRef{Elorrieta_2019}{iAR}
}
