\name{constructor}
\alias{constructor}
\alias{constructors}
\alias{constructor_2020}
\alias{constructor_2020_maxp}
\alias{constructor_table_2020}
\alias{constructor_2020_table}
\alias{constructor_2021}
\alias{constructor_2021_maxp}
\alias{constructor_table_2021}
\alias{constructor_2021_table}
\docType{data}
\title{Formula 1 dataset: the constructors' championship}
\description{Race results from 2017 Formula One constructors' Championship}
\usage{
data(constructor)
}
\format{A \code{hyper3} object that gives a likelihood function}
\details{

The Constructors championship runs parallel to the Formula 1 drivers'
championship.  Each constructor fields two drivers.  We have data from
2020 and 2021, following applies to both years.

Object \code{constructor_table_2021} is a dataframe, taken from
Wikipedia, showing 

Object \code{constructor_2021_maxp} gives the maximum likelihood
estimate for the constructors' strengths.  The first column is the name
of the constructor, the next 22 show the ranks of the constructors, and
the final one is the points awarded.

The corresponding \code{hyper3} likelihood function
\code{constructor_2021} is produced by \code{ordertable2supp3()}.

These objects can be generated by running script \code{inst/race3.Rmd},
which includes some further discussion and technical documentation, and
creates file \code{constructor.rda} which resides in the \code{data/}
directory.

}
\references{

  Wikipedia contributors. (2022, April 14). 2021 Formula One World
  Championship. In _Wikipedia, The Free Encyclopedia_. Retrieved 05:16,
  April 17, 2022, from
  \url{https://en.wikipedia.org/w/index.php?title=2021_Formula_One_World_Championship&oldid=1082745216}
 
  }
\seealso{\code{\link{formula1}}}
\examples{
dotchart(constructor_2021_maxp)
}
