% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_hm_report.R
\name{hm_report}
\alias{hm_report}
\alias{hm_report,hydromet_station-method}
\alias{hm_report,hydromet_compact-method}
\title{Get a summary report of your data}
\usage{
hm_report(obj, slot_name, col_name = "all")

\S4method{hm_report}{hydromet_station}(obj, slot_name, col_name = "all")

\S4method{hm_report}{hydromet_compact}(obj, slot_name = "compact", col_name = "all")
}
\arguments{
\item{obj}{a valid \code{hydromet_XXX} class object.}

\item{slot_name}{string with the name of the slot to report.}

\item{col_name}{string vector with the column(s) name(s) to report. By default
the function will do it in all columns inside the slot.}
}
\value{
A list summarizing basic statistics and missing data.
The missing data table presents a data frame (one per \code{col_name})
with three columns: start-date, end-date and number of missing
time steps. In the last row of this table you will find the total
number of missing measurements (under "time_step" column). The
"first" and "last" columns will have a \code{NA_character} for
this last row.
}
\description{
Returns a list with two elements: the first one contains basic
statistics (\code{mean}, \code{sd}, \code{max} and \code{min}) values and
the second one is a table with summary of miss data (see also \link{report_miss}).
}
\section{Functions}{
\itemize{
\item \code{hm_report(hydromet_station)}: report method for station class

\item \code{hm_report(hydromet_compact)}: report method for compact class

}}
\examples{
\dontrun{
# cuevas station
path <- system.file('extdata', package = 'hydrotoolbox')

# use the build method
hm_cuevas <-
  hm_create() \%>\%
  hm_build(bureau = 'ianigla', path = path,
           file_name = 'ianigla_cuevas.csv',
           slot_name = c('tair', 'rh', 'patm',
                         'precip', 'wspd', 'wdir',
                         'kin', 'hsnow', 'tsoil'),
           by = 'hour',
           out_name = c('tair(°C)', 'rh(\%)', 'patm(mbar)',
                        'p(mm)', 'wspd(km/hr)', 'wdir(°)',
                        'kin(kW/m2)', 'hsnow(cm)', 'tsoil(°C)' )
          )

# report incoming solar radiation
hm_report(obj = hm_cuevas, slot_name = 'kin')
}

}
