% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_read_cr2.R
\name{read_cr2}
\alias{read_cr2}
\title{Reads data from Explorador Climático (CR2 - Chile)}
\usage{
read_cr2(path, by = "day", out_name = NULL)
}
\arguments{
\item{path}{path to the csv file.}

\item{by}{string with the time step of the series (e.g.: \code{'month', 'day',
'6 hour', '3 hour', '1 hour', '15 min' }). The default and unique possible
value is \code{'day'}.}

\item{out_name}{optional. String vector with user defined variable(s)
column(s) name(s).}
}
\value{
A data frame with the data inside the csv file. Gaps between dates are
 filled with \code{NA_real_} and duplicated rows are eliminated automatically.
}
\description{
Reads csv files downloaded from the CR2 web page as a data frame.
}
\examples{

# list cr2 files
list.files( system.file('extdata', package = 'hydrotoolbox'), pattern = 'cr2' )

# set path to file
path_tmax <- system.file('extdata', 'cr2_tmax_yeso_embalse.csv',
             package = 'hydrotoolbox')

# read file with default colname
head( read_cr2(path = path_tmax) )

# assign a column name
head( read_cr2(path = path_tmax, out_name = 'tmax(°C)') )

}
