% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w80ToSpatial.R
\name{w80ToSFL}
\alias{w80ToSFL}
\title{Function to convert w80-files to \code{sfc_LINESTRING}.}
\usage{
w80ToSFL(
  filename,
  crs,
  id = c("sid", "fwid", "wsvpt", "station", "bank", "id", "x", "y", "date_coor",
    "acc_coor", "z", "date_z", "acc_z", "tom", "comment", "status", "lat", "lon",
    "station_int", "station_c")
)
}
\arguments{
\item{filename}{argument of length 1 and type \code{character} specifying
an existing w80-file.}

\item{crs}{argument of type \code{\link[sp]{CRS}} or \code{\link[terra]{crs}}.}

\item{id}{argument of type \code{character} specifying a grouping column.}
}
\value{
\code{sfc_LINESTRING}.
}
\description{
This function converts w80-files, an ascii-format with 80
characters per line for spatial point data used by the German Waterways and
Shipping Administration (WSV). Every single row codes for one point:

\code{|_1_|2_|_3______|4|____________5______________|_______6_______|_____7___|_8_|} \cr

\code{W0701 55 2594611   1330938065557502425901108035 5795591108035         Bu.15   01} \cr

\code{W0701 57 2594611   7330932961457502484041108035 5538181108035         Bu.15   01} \cr

Within each row very specific sections code for specific attributes:\tabular{cllr}{
   \strong{section} \tab \strong{column(s)} \tab \strong{attribute} \tab \strong{column name in result} \cr
   1 \tab 1 \tab state id, here W=WSV \tab sid \cr
   1 \tab 2-5 \tab Federal Waterway ID \tab fwid \cr
   2 \tab 6-8 \tab WSV point type \tab wsvpt \cr
   3 \tab 9 \tab blank \tab - \cr
   3 \tab 10-15 \tab river station (km) \tab station \cr
   4 \tab 16 \tab bank: 1 left, 2 right \tab bank \cr
   4 \tab 17-20 \tab continuous id \tab id \cr
   5 \tab 21-30 \tab easting in GK-coordinates \tab x \cr
   5 \tab 31-40 \tab northing in GK-coordinates \tab y \cr
   6 \tab 41-46 \tab datum of measurement \tab date_coor \cr
   6 \tab 47 \tab accuracy \tab acc_coor \cr
   6 \tab 48-54 \tab elevation \tab z \cr
   6 \tab 55-60 \tab date of the elevation measurement \tab date_z \cr
   6 \tab 61 \tab accuracy of the elevation measurement \tab acc_z \cr
   6 \tab 62-64 \tab type of measurement \tab tom \cr
   7 \tab 65-84 \tab comment \tab comment \cr
   8 \tab 85-86 \tab point status \tab status \cr
}


In a second step these points are aggregated to a
\code{sfc_LINESTRING} using the grouping column \code{id}.
}
\examples{
  options("hydflood.datadir" = tempdir())
  library(hydflood)
  c <- st_crs("EPSG:25833")
  filename <- tempfile(fileext = ".w80")
  
  # write temporary w80 file
  cat("W0701 55 2594611   1330938065557502425901108035 5795591108035         Bu.15   01\n",
      file = filename)
  cat("W0701 57 2594611   7330932961457502484041108035 5538181108035         Bu.15   01\n",
      file = filename, append = TRUE)
  
  # import temporary w80 file as sf LINESTRING
  sl <- w80ToSFL(filename, c, "station_int")

}
