% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifyToPNV.R
\name{classifyToPNV}
\alias{classifyToPNV}
\title{Function to reclassify flood durations to potential natural vegetation}
\usage{
classifyToPNV(x, rcl = NULL, filename = "", ...)
}
\arguments{
\item{x}{argument of type \code{\link[terra]{SpatRaster}}.}

\item{rcl}{optional argument of type \code{data.frame} with columns and
column types as specified in \code{\link{df.pnv}}.}

\item{filename}{supplies an optional output filename of type
\code{character}.}

\item{\dots}{additional arguments as for \code{\link[terra]{writeRaster}}.}
}
\value{
\code{\link[terra]{SpatRaster}} object containing potential natural
vegetation distribution as categorical raster.
}
\description{
This function is a wrapper to the function
\code{\link[terra]{classify}} to convert flood durations computed with
\code{\link{flood3}} into potential natural vegetation (PNV) distributions using
reclassification rules supplied with \code{\link{df.pnv}}. Alternative
reclassification rules may be applied, but they must match column names and
types as given by \code{\link{df.pnv}}. \code{\link[terra]{classify}} is
called with \code{include.lowest = TRUE}, \code{right = FALSE} and
\code{othersNA = TRUE}.
}
\examples{
\donttest{
  cache <- tempdir()
  options("hyd1d.datadir" = cache)
  options("hydflood.datadir" = cache)
  options(timeout = 200)
  library(hydflood)
  
  # import the raster data and create a raster stack
  c <- st_crs("EPSG:25833")
  e <- ext(309000, 310000, 5749000, 5750000)
  x <- hydSpatRaster(ext = e, crs = c)
  
  # create a temporal sequence
  seq <- seq(as.Date("2016-01-01"), as.Date("2016-12-31"), by = "day")
  
  # compute a flood duration
  fd <- flood3(x = x, seq = seq)
  
  # reclassify to PNV
  pnv <- classifyToPNV(fd)
  
  # plot pnv map
  plot(pnv)
}

}
\references{
\insertRef{ochs_potential_2020}{hydflood}
}
\seealso{
\code{\link{df.pnv}}
}
