% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethCl_CS_Arbitrary.R
\name{wetted_perimeter}
\alias{wetted_perimeter}
\alias{wetted_perimeter,CSarbitrary-method}
\alias{wetted_perimeter,CScircle-method}
\title{Wetted Perimeter}
\usage{
wetted_perimeter(object, h, ret = "P")
}
\arguments{
\item{object}{An object of class CSarbitrary or CScircle.}

\item{h}{A numeric vector of water levels (m). For CScircle, only a
single numeric value is allowed.}

\item{ret}{A character string. If `P`, returns total wetted perimeter.
If `Pii`, returns wetted perimeter by segment.}
}
\value{
A numeric vector or matrix of wetted perimeter based on the `ret`
  argument.
}
\description{
Calculates the wetted perimeter of a CSarbitrary or CScircle
  object for given water levels.
}
\examples{
# Example for CSarbitrary object
x <- c(0, 4, 9, 13)
z <- c(2, 0, 0, 2)
cs <- CSarbitrary(x = x, z = z, xb_l = 4, xb_r = 9, kSt_B = 35,
                  kSt_l = 45, kSt_r = 45)

# Calculate total wetted perimeter at water levels 1 m and 2 m
h <- c(1, 2)
wetted_perimeter(cs, h, ret = "P")

# Calculate wetted perimeter for each segment at the same water levels
wetted_perimeter(cs, h, ret = "Pii")

# Example for CScircle object
csC <- CScircle(Di = 1, kSt = 75)

# Calculate total wetted perimeter at water level 1 m
h <- 1
wetted_perimeter(csC, h)
}
