% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gate.R
\name{flow_depth_gate}
\alias{flow_depth_gate}
\title{Water Depth Upstream Of Gate}
\usage{
flow_depth_gate(a, Q, B, alpha, h2 = NULL, ret = "h0")
}
\arguments{
\item{a}{Gate opening height [m].}

\item{Q}{Discharge [m3/s].}

\item{B}{Gate width [m].}

\item{alpha}{Gate angle from horizontal [degrees].}

\item{h2}{Optional. Downstream water depth [m]. Default is NULL (free flow).}

\item{ret}{Specifies the return value. "h0" for depth only or "all" for
all intermediate results.}
}
\value{
A list containing the following hydraulic variables:
\describe{
  \item{h0}{Upstream water depth [m].}
  \item{psi}{Contraction coefficient [-].}
  \item{mu}{Discharge coefficient [-].}
  \item{v}{Flow velocity [m/s].}
}
}
\description{
Calculates the upstream water depth for a gate based on given
  discharge and gate parameters.
}
\examples{
flow_depth_gate(a = 0.5, Q = 2.5, B = 2.0, alpha = 90)
flow_depth_gate(a = 0.5, Q = 2.5, B = 2.0, alpha = 90, h2 = 0.8)
flow_depth_gate(a = 0.5, Q = 2.5, B = 2.0, alpha = 90, h2 = 0.8, ret = "all")
}
