% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterLevelFlys3.R, R/waterLevelFlys3Seq.R
\name{waterLevelFlys3}
\alias{waterLevelFlys3}
\alias{waterLevelFlys3Seq}
\title{Obtain 1d water level data from the FLYS3 database}
\usage{
waterLevelFlys3(wldf, name)

waterLevelFlys3Seq(river = c("Elbe", "Rhine"), name, from, to)
}
\arguments{
\item{wldf}{an object of class \linkS4class{WaterLevelDataFrame}.}

\item{name}{a string with the name of a stationary 
\href{https://www.bafg.de/DE/5_Informiert/1_Portale_Dienste/FLYS/flys_node.html}{FLYS3}
water level. It has 
to be type \code{character}, has to have a length of
one and has to be an element of the \code{river}-specific names specified 
in Details.}

\item{river}{a required argument to fill the \linkS4class{WaterLevelDataFrame}-slot
\code{river}. It has to be type \code{character}, has to have a length of
one and can be either \strong{Elbe} or \strong{Rhine}.}

\item{from}{\code{numeric} or \code{integer} for the upstream station. It
has to have a length of one and has to be within the \code{river}-specific
possible station range specified in Details.}

\item{to}{\code{numeric} or \code{integer} for the downstream station. It
has to have the same type as \code{from}, a length of one and has to be 
within the \code{river}-specific possible station range specified in 
Details.}
}
\value{
An object of class \linkS4class{WaterLevelDataFrame}.
}
\description{
Obtain 1d water level data from the
  \href{https://www.bafg.de/DE/5_Informiert/1_Portale_Dienste/FLYS/flys_node.html}{FLYS3}
  database using either 
  a predefined \linkS4class{WaterLevelDataFrame} or \code{river}, \code{from} 
  and \code{to} arguments that enable the internal construction of a 
  \linkS4class{WaterLevelDataFrame}. The internally constructed 
  \linkS4class{WaterLevelDataFrame} contains stations every 0.1 km or 100 m 
  between the given range of \code{from} and \code{to}.
}
\details{
Possible \code{name}s of \href{https://www.bafg.de/DE/5_Informiert/1_Portale_Dienste/FLYS/flys_node.html}{FLYS3} water levels and ranges of \code{from} and \code{to} are river-specific:

\strong{Elbe:}

'0.5MNQ', 'MNQ', '0.5MQ', 'a', '0.75MQ', 'b', 'MQ', 'c', '2MQ', '3MQ', 'd', 'e', 'MHQ', 'HQ2', 'f', 'HQ5', 'g', 'h', 'HQ10', 'HQ15', 'HQ20', 'HQ25', 'HQ50', 'HQ75', 'HQ100', 'i', 'HQ150', 'HQ200', 'HQ300', 'HQ500'

Possible range of \code{from} and \code{to}: type \code{numeric} (km) 0 - 585.7, type \code{integer} (m) 0 - 585700.

\strong{Rhine:}

'Ud=1', 'Ud=5', 'GlQ2012', 'Ud=50', 'Ud=80', 'Ud=100', 'Ud=120', 'Ud=183', 'MQ', 'Ud=240', 'Ud=270', 'Ud=310', 'Ud=340', 'Ud=356', 'Ud=360', 'MHQ', 'HQ2', 'HQ5', 'HQ5-10', 'HQ10', 'HQ10-20', '~HQ20', 'HQ20-50', 'HQ50', 'HQ50-100', 'HQ100', 'HQ100-200', 'HQ200', 'HQ200-ex', 'HQextr.'

Possible range of \code{from} and \code{to}: type \code{numeric} (km) 336.2 - 865.7, type \code{integer} (m) 336200 - 865700.

Both lists of water levels are ordered from low to high water levels.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
wldf1 <- waterLevelFlys3(wldf, "MQ")

wldf2 <- waterLevelFlys3Seq("Elbe", "MQ", 257, 262)

}
\references{
\insertRef{busch_einheitliche_2009}{hyd1d}
  
  \insertRef{hkv_hydrokontor_erstellung_2014}{hyd1d}
  
  \insertRef{bundesanstalt_fur_gewasserkunde_flys_2013}{hyd1d}
  
  \insertRef{bundesanstalt_fur_gewasserkunde_flys_2016}{hyd1d}
}
\seealso{
\code{\link{df.flys}}, \code{\link{plotShiny}}
}
