% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{qqpvalue}
\alias{qqpvalue}
\title{QQ-plot for p-values}
\usage{
qqpvalue(
  pvals,
  method = c("ggplot2", "base"),
  band_type = c("ts", "pointwise"),
  conf_level = 0.95
)
}
\arguments{
\item{pvals}{A vector of p-values.}

\item{method}{Should we use base plotting or ggplot2 (if installed)?}

\item{band_type}{Should we use the method of Aldor-Noiman et al (2013) or
pointwise based on beta? Pointwise is not recommended since there is
strong dependence between order statistics, and if one is beyond
the pointwise bands, then likely lots are also beyond them.}

\item{conf_level}{Confidence level for the bands.}
}
\description{
This will create a QQ-plot for p-values, comparing them to a uniform
distribution. We make our plot on the -log10 scale. We calculate
simultaneous confidence bands by the Tail Sensitive approach of
Aldor-Noiman et al (2013).
}
\examples{
set.seed(1)
pvals <- runif(100)
qqpvalue(pvals, band_type = "ts", method = "base")

\dontrun{
qqpvalue(pvals, band_type = "ts", method = "ggplot2")
}

}
\references{
\itemize{
\item{Aldor-Noiman, S., Brown, L. D., Buja, A., Rolke, W., & Stine, R. A. (2013). The power to see: A new graphical test of normality. The American Statistician, 67(4), 249-260.}
}
}
\seealso{
\itemize{
\item{The \code{qqPlot()} function from the car package.}
}
}
\author{
David Gerard
}
