% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge_across}
\alias{merge_across}
\alias{merge_down}
\title{Merge cells across rows or down columns}
\usage{
merge_across(ht, row, col)

merge_down(ht, row, col)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}
}
\value{
The \code{ht} object.
}
\description{
\code{merge_across()} creates multicolumn cells within each row.
\code{merge_down()} creates multirow cells within each column.
}
\section{Cell content}{

In merged cell ranges, only the top left cell's content is displayed.
In addition, when you merge cells (either by setting \code{\link[=colspan]{colspan()}} or
\code{\link[=rowspan]{rowspan()}}, or using \code{\link[=merge_cells]{merge_cells()}} and friends) the content of the top
left cell is copied to other cells. This prevents unexpected changes to
content if you reorder or subset rows and columns.
}

\examples{

ht <- as_hux(matrix(1:12, 4, 3, byrow = TRUE))
ht <- set_all_borders(ht, 1)
merge_across(ht, 2:4, 2:3)
merge_down(ht, 2:4, 2:3)

}
\seealso{
Other cell merging: 
\code{\link{merge_cells}()},
\code{\link{merge_repeated_rows}()}
}
\concept{cell merging}
