% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset-extract.R
\name{[.huxtable}
\alias{[.huxtable}
\alias{[<-.huxtable}
\alias{$<-.huxtable}
\alias{[[<-.huxtable}
\title{Subset a huxtable}
\usage{
\method{[}{huxtable}(x, i, j, drop = FALSE)

\method{[}{huxtable}(x, i, j) <- value

\method{$}{huxtable}(x, name) <- value

\method{[[}{huxtable}(x, i, j) <- value
}
\arguments{
\item{x}{A huxtable.}

\item{i}{Rows to select.}

\item{j, name}{Columns to select.}

\item{drop}{Only included for compatibility with \verb{[.data.frame}. Do not use.}

\item{value}{A matrix, data frame, huxtable or similar object.}
}
\value{
\code{[} returns a huxtable. \code{$} and \code{[[} return data from the
underlying data frame.
}
\description{
Subset a huxtable
}
\section{Replacing existing rows and columns}{
For the replacement function \verb{[<-}, if \code{value} is a huxtable, then its
properties will be copied into \code{x}. Replacement functions \verb{$<-} and \verb{[[<-}
replace existing data without affecting any properties.
}

\section{Adding new rows and columns}{
If new columns or rows are created, then properties will be copied
from the last column or row of \code{x}, or from \code{value} if \code{value} is a huxtable.

These methods are stricter than their data frame equivalents in some places.
You can't add new rows or column at a numeric location without specifying all
intervening rows/columns. New values must have the appropriate dimensions
(vectors will be interpreted appropriately).
}

\examples{
jams[1:3, ]
class(jams[1:3, ])
jams[, 1]
jams$Type
prices <- huxtable(c("Price", 1.70, 2.00, 2.20))
number_format(prices) <- 2
bold(prices) <- TRUE
jams[, 2] <- prices
jams

data(jams)
jams$price <- c("Price", 1.70, 2.00, 2.20)
jams
}
