% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{text_color}
\alias{text_color}
\alias{text_color<-}
\alias{set_text_color}
\alias{map_text_color}
\title{Text color}
\usage{
text_color(ht)
text_color(ht) <- value
set_text_color(ht, row, col, value, byrow = FALSE)
map_text_color(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A character vector or matrix of valid R colors.

Set to \code{NA} to reset to the default, which is \code{NA}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{byrow}{Deprecated. Use \code{\link[=by_cols]{by_cols()}} instead.}
}
\value{
For \code{text_color}, the \code{text_color} property.
For \code{set_text_color} and \code{map_text_color}, the modified huxtable.
}
\description{
Functions to get or set the \emph{text color} property of huxtable cells.
}
\details{
Colors can be in any format understood by R, e.g. \code{"red"}, \code{"#FF0000"} or \code{rgb(1, 0, 0)}.
}
\examples{

orig <- text_color(jams)
text_color(jams) <-  "blue"
text_color(jams)

text_color(jams) <- orig

set_text_color(jams, "blue")
set_text_color(jams,
      2:3, 1, "blue")
map_text_color(jams,
      by_rows("blue", "red"))
}
\seealso{
Other formatting functions: \code{\link{background_color}},
  \code{\link{bold}}, \code{\link{font_size}},
  \code{\link{font}}, \code{\link{na_string}},
  \code{\link{number_format}}
}
\concept{formatting functions}
