% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{caption}
\alias{caption}
\alias{caption<-}
\alias{set_caption}
\alias{caption.huxtable}
\alias{caption<-.huxtable}
\title{Caption}
\usage{
caption(ht)
caption(ht) <- value
set_caption(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A length-one character vector. Set to \code{NA} for no caption.}
}
\value{
For \code{caption}, the \code{caption} attribute.
For \code{set_caption}, the \code{ht} object.
}
\description{
Functions to get or set the table-level caption property of a huxtable.
}
\details{
Captions are not escaped. See the example for a workaround.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
caption(ht) <-  'An example table'
caption(ht)
print_screen(ht)
ht <- hux(a = 1:2, b = 1:2)
caption(ht) <- sanitize('Make $$$ with us', type = 'latex') # escape caption characters
}
\seealso{
\code{\link[=caption_pos]{caption_pos()}}
}
