% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row-col-fns.R
\name{rowspecs}
\alias{rowspecs}
\title{Row and column specifications}
\description{
Row and column specifications
}
\section{The basics}{


The \code{set_*} functions for cell properties all have arguments like this:
\code{set_property(ht, row, col, value, byrow = FALSE)}.

You can treat \code{row} and \code{col} arguments like arguments to \code{[} for a data frame.
But there are a few extra tricks:

\itemize{
 \item Write \code{set_property(ht, x)}, omitting \code{row} and \code{col}, to set
   the property to \code{x} for all cells.
 \item Use \code{\link{everywhere}} to refer to all rows or all columns.
 \item Use \code{\link[=final]{final(n)}} to refer to the last n rows or columns.
 \item Use \code{\link{evens}} to get only even rows/columns and \code{\link{odds}}
   for only odd ones.
 \item Use \code{\link[=every]{every(n, from = m)}} to get every nth row/column starting at row/column m.
 \item Use \code{dplyr} functions like \code{starts_with}, \code{contains} and \code{matches} to
   specify columns (but not rows). See \code{\link[dplyr]{select_helpers}} for a full list.
 \item Use \code{\link[=where]{where(cond)}}, and omit the \code{col} argument, to get cells where \code{cond} is
   \code{TRUE}.
 \item Set \code{byrow = TRUE} to set properties by row rather than by column.
}
}

\section{The gory details}{


How the row and col arguments are parsed depends on the number of arguments passed to the \code{set_*}
function.

\itemize{
  \item If there are two arguments (excluding \code{byrow}) then the second argument is taken as the
    value and is set for all rows and columns.
  \item If there are three arguments, then the third argument is taken as the value, and
    \code{row} must be a matrix with two columns. Each row of this matrix
    gives the row, column indices of a single cell. This uses R's little known feature of
    subsetting with matrices - see \code{\link[base]{Extract}}.
  \item If there are four arguments:
    \itemize{
      \item If \code{row} or \code{col} is numeric, character or logical, it is evaluated just as in standard
        subsetting. \code{col} will be evaluated in a special context provided by \code{\link[tidyselect]{with_vars}}
        to allow the use of dplyr functions.
      \item If \code{row} or \code{col} is a function,it is called with two arguments: the huxtable,
        and the dimension number being evaluated, i.e. 1 for rows, 2 for columns. It must return a vector
        of column indices. \code{\link{evens}}, \code{\link{odds}}, \code{\link{every}} and \code{\link{final}}
       return functions for this purpose.
    }
}
}

\examples{
ht <- huxtable(a = 1:5, b = 5:1)

set_bold(ht, 2:4, 1:2, TRUE)
set_bold(ht, odds, evens, TRUE)
set_bold(ht, everywhere, tidyselect::matches('[aeiou]'), TRUE)

set_bold(ht, where(ht == 1), TRUE)

set_text_color(ht, 2:3, 1:2, c('red', 'blue'))
set_text_color(ht, 2:3, 1:2, c('red', 'blue'), byrow = TRUE)
}
