% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{align}
\alias{align}
\alias{align<-}
\alias{set_align}
\alias{align.huxtable}
\alias{align<-.huxtable}
\title{Alignment}
\usage{
align(ht)
align(ht) <- value
set_align(ht, row, col, value, byrow = FALSE)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A character vector or matrix which may be 'left', 'center', 'right' or \code{NA}. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier. See \code{\link{rowspecs}} for details.}

\item{col}{An optional column specifier.}

\item{byrow}{If \code{TRUE}, fill in values by row rather than by column.}
}
\value{
For \code{align}, the \code{align} attribute.
For \code{set_align}, the \code{ht} object.
}
\description{
Functions to get or set the alignment property of huxtable table cells.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
align(ht) <-  'right'
align(ht)


ht <- huxtable(a = 1:3, b = 3:1)
set_align(ht, 'right')
set_align(ht, 1:2, 1, 'right')
set_align(ht, 1:2, 1:2, c('right', 'left'), byrow = TRUE)
set_align(ht, where(ht == 1), 'right')
}
