% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_footnote}
\alias{add_footnote}
\title{Add a row with a footnote}
\usage{
add_footnote(ht, text, ...)
}
\arguments{
\item{ht}{A huxtable.}

\item{text}{Text for the footnote.}

\item{...}{Other properties, passed to \code{\link{set_cell_properties}} for the footnote cell.}
}
\value{
The modified huxtable
}
\description{
This adds a single row at the bottom. The first cell contains the footnote; it spans
the entire table and has a border above only.
}
\examples{
ht <- hux(a = 1:5, b = 1:5, d = 1:5)
ht <- add_footnote(ht, '* this is a footnote')
ht
}
