% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implies.R
\name{implies}
\alias{implies}
\alias{\%implies\%}
\title{#' Logical implies}
\usage{
implies(x, y)

x \%implies\% y
}
\arguments{
\item{x, y}{Logical vectors of the same length.}
}
\value{
\code{TRUE} along \code{y} unless \code{x} is \code{TRUE} and \code{y} is \code{FALSE}.
}
\description{
Returns the result of \eqn{x\Longrightarrow y}.
}
\examples{
 
library(data.table)
CJ(x = c(TRUE,
         FALSE),
   y = c(TRUE,
         FALSE))[, ` x => y` := x \%implies\% y][]

#>        x     y  x => y
#> 1: FALSE FALSE    TRUE
#> 2: FALSE  TRUE    TRUE
#> 3:  TRUE FALSE   FALSE
#> 4:  TRUE  TRUE    TRUE

# NA results:
#> 5:    NA    NA      NA
#> 6:    NA FALSE      NA
#> 7:    NA  TRUE    TRUE
#> 8: FALSE    NA    TRUE
#> 9:  TRUE    NA      NA
}
