% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray_datasets.R
\docType{data}
\name{ImmunoChipB37}
\alias{ImmunoChipB37}
\title{ImmunoChip annotation object (built-in)}
\format{An object of class GRanges}
\description{
Dataset. This object contains chromosome, position, chip SNP labels,
SNP rs-ids, for immunochip, plus allele codes based on a UVA/Sanger 
T1D dataset, which should be updated for use with a different dataset
with different allele coding (however the position and rs-id information
should still be applicable.
The data is in build 37 coordinates as a ChipInfo object, but using functions
convTo36 or convTo38 from the humarray package can easily convert this to
build 36 or 38.
}
\examples{
data(ImmunoChipB37)
\donttest{ImmunoChipB36 <- convTo36(ImmunoChipB37) }
}
\seealso{
\code{\link{convTo38}} \code{\link{convTo36}}
 \code{\link{A1}}
}
\keyword{datasets}
