% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth.R
\name{oauth_token_cached}
\alias{oauth_token_cached}
\title{Retrieve an OAuth token using the cache}
\usage{
oauth_token_cached(
  client,
  flow,
  flow_params = list(),
  cache_disk = FALSE,
  cache_key = NULL,
  reauth = FALSE
)
}
\arguments{
\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{flow}{An \code{oauth_flow_} function used to generate the access token.}

\item{flow_params}{Parameters for the flow. This should be a named list
whose names match the argument names of \code{flow}.}

\item{cache_disk}{Should the access token be cached on disk? This reduces
the number of times that you need to re-authenticate at the cost of
storing access credentials on disk.

Learn more in \url{https://httr2.r-lib.org/articles/oauth.html}.}

\item{cache_key}{If you want to cache multiple tokens per app, use this
key to disambiguate them.}

\item{reauth}{Set to \code{TRUE} to force re-authentication via flow, regardless
of whether or not token is expired.}
}
\description{
This function wraps around a \code{oauth_flow_} function to retrieve a token
from the cache, or to generate and cache a token if needed. Use this for
manual token management that still takes advantage of httr2's caching
system. You should only need to use this function if you're passing
the token
}
\examples{
\dontrun{
token <- oauth_token_cached(
  client = example_github_client(),
  flow = oauth_flow_auth_code,
  flow_params = list(
    auth_url = "https://github.com/login/oauth/authorize"
  ),
  cache_disk = TRUE
)
token
}
}
\keyword{internal}
