% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-password.R
\name{req_oauth_password}
\alias{req_oauth_password}
\title{OAuth authentication with username and password}
\usage{
req_oauth_password(
  req,
  client,
  username,
  password = NULL,
  cache_disk = FALSE,
  scope = NULL,
  token_params = list()
)
}
\arguments{
\item{req}{A \link{request}.}

\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{username}{User name.}

\item{password}{Password. You avoid entering the password directly when
calling this function as it will be captured by \code{.Rhistory}. Instead,
leave it unset and the default behaviour will prompt you for it
interactively.}

\item{cache_disk}{Should the access token be cached on disk? This reduces
the number of times that you need to re-authenticate at the cost of
storing access credentials on disk. Cached tokens are encrypted and
automatically deleted 30 days after creation.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}
}
\value{
A modified HTTP \link{request}.
}
\description{
This uses \code{\link[=oauth_flow_password]{oauth_flow_password()}} to generate an access token, which is
then used to authentication the request with \code{\link[=req_auth_bearer_token]{req_auth_bearer_token()}}.
The token, not the password is automatically cached (either in memory
or on disk); the password is used once to get the token and is then
discarded.
}
\examples{
client <- oauth_client("example", "https://example.com/get_token")
req <- request("https://example.com")

if (interactive()) {
  req \%>\% req_oauth_password(client, "username")
}
}
