% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_analytic_css_pbtk.R
\name{calc_analytic_css_pbtk}
\alias{calc_analytic_css_pbtk}
\title{Calculate the analytic steady state plasma concentration for model pbtk.}
\usage{
calc_analytic_css_pbtk(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  species = "Human",
  parameters = NULL,
  dosing = list(daily.dose = 1),
  hourly.dose = NULL,
  dose.units = "mg",
  concentration = "plasma",
  suppress.messages = FALSE,
  recalc.blood2plasma = FALSE,
  tissue = NULL,
  restrictive.clearance = TRUE,
  bioactive.free.invivo = FALSE,
  Caco2.options = list(),
  ...
)
}
\arguments{
\item{chem.name}{Either the chemical name, CAS number, or the parameters must 
be specified.}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must 
be specified.}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{parameters}{Chemical parameters from parameterize_pbtk (for model = 
'pbtk'), parameterize_3comp (for model = '3compartment), 
parameterize_1comp(for model = '1compartment') or parameterize_steadystate 
(for model = '3compartmentss'), overrides chem.name and chem.cas.}

\item{dosing}{List of dosing metrics used in simulation, which includes
the namesake entries of a model's associated dosing.params. For steady-state
calculations this is likely to be either "daily.dose" for oral exposures or
"Cinhaled" for inhalation.}

\item{hourly.dose}{Hourly dose rate mg/kg BW/h.}

\item{dose.units}{The units associated with the dose received.}

\item{concentration}{Desired concentration type, 'blood', 'tissue', or default 'plasma'.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{recalc.blood2plasma}{Recalculates the ratio of the amount of chemical 
in the blood to plasma using the input parameters. Use this if you have 
altered hematocrit, Funbound.plasma, or Krbc2pu.}

\item{tissue}{Desired tissue conentration (defaults to whole body 
concentration.)}

\item{restrictive.clearance}{If TRUE (default), then only the fraction of
chemical not bound to protein is available for metabolism in the liver. If 
FALSE, then all chemical in the liver is metabolized (faster metabolism due
to rapid off-binding).}

\item{bioactive.free.invivo}{If FALSE (default), then the total concentration is treated
as bioactive in vivo. If TRUE, the the unbound (free) plasma concentration is treated as 
bioactive in vivo. Only works with tissue = NULL in current implementation.}

\item{Caco2.options}{A list of options to use when working with Caco2 apical to
basolateral data \code{Caco2.Pab}, default is Caco2.options = list(Caco2.Pab.default = 1.6,
Caco2.Fabs = TRUE, Caco2.Fgut = TRUE, overwrite.invivo = FALSE, keepit100 = FALSE). Caco2.Pab.default sets the default value for 
Caco2.Pab if Caco2.Pab is unavailable. Caco2.Fabs = TRUE uses Caco2.Pab to calculate
fabs.oral, otherwise fabs.oral = \code{Fabs}. Caco2.Fgut = TRUE uses Caco2.Pab to calculate 
fgut.oral, otherwise fgut.oral = \code{Fgut}. overwrite.invivo = TRUE overwrites Fabs and Fgut in vivo values from literature with 
Caco2 derived values if available. keepit100 = TRUE overwrites Fabs and Fgut with 1 (i.e. 100 percent) regardless of other settings.
See \code{\link{get_fbio}} for further details.}

\item{...}{Additional parameters passed to parameterize function if 
parameters is NULL.}
}
\value{
Steady state plasma concentration in mg/L units
}
\description{
This function calculates the analytic steady state concentration (mg/L) as a result
of constant oral infusion dosing. 
Concentrations are returned for plasma by default, but various
tissues or blood concentrations can also be given as specified.
}
\details{
The PBTK model \insertCite{pearce2017httk}{httk} predicts the amount of chemical in
various tissues of the body. A system of ordinary
differential equations describes how the amounts in each tissue change as 
a function of time. The analytic steady-state equation was found by 
algebraically solving for the tissue concentrations that result in each
equation being zero -- thus determining the concentration at which there is no change
over time as the result of a fixed infusion dose rate. 

The analytical solution is:
\deqn{C^{ss}_{ven} = \frac{dose rate * \frac{Q_{liver} + Q_{gut}}{\frac{f_{up}}{R_{b:p}}*Cl_{metabolism} + (Q_{liver}+Q_{gut})}}{Q_{cardiac} - \frac{(Q_{liver} + Q_{gut})^2}{\frac{f_{up}}{R_{b:p}}*Cl_{metabolism} + (Q_{liver}+Q_{gut})} - \frac{(Q_{kidney})^2}{\frac{f_{up}}{R_{b:p}}*Q_{GFR}+Q_{kideny}}-Q_{rest}}}{%
C_ven_ss =(dose rate * (Q_liver + Q_gut) / (f_up/Rb2p*Cl_metabolism + (Q_liver + Qgut)))/(Q_cardiac - (Q_liver + Qgut)^2/(f_up/Rb2p*Cl_metabolism + (Q_liver + Qgut)) - (Q_kidney)^2/(f_up/Rb2p*Q_gfr + Q_kidney) - Q_rest)}
\deqn{C^{ss}_{plasma} = \frac{C^{ss}_{ven}}{R_{b:p}}}{%
      C_ss = C_ven_ss/Rb2p}
\deqn{C^{ss}_{tissue} = \frac{K_{tissue:fuplasma}*f_{up}}{R_{b:p}}*C^{ss}_{ven}}{%
       C_tissue_ss = K_tissue2fuplasma*f_up*C_ven_ss/Rb2p}
 where Q_cardiac is the cardiac output, Q_gfr is the glomerular filtration
rate in the kidney, other Q's indicate blood flows to various tissues, 
Cl_metabolism is the chemical-specific whole liver metabolism clearance,
f_up is the chemical-specific fraction unbound in plasma, R_b2p is the 
chemical specific ratio of concentrations in blood:plasma, K_tissue2fuplasma
is the chemical- and tissue-specific equilibrium partition coefficient
and dose rate has  units of mg/kg/day.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{calc_analytic_css}}

\code{\link{parameterize_pbtk}}
}
\author{
Robert Pearce and John Wambaugh
}
\keyword{pbtk}
\keyword{steady-state}
