% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_analytic_css_1comp.R
\name{calc_analytic_css_1comp}
\alias{calc_analytic_css_1comp}
\title{Calculate the analytic steady state concentration for the one compartment model.}
\usage{
calc_analytic_css_1comp(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  parameters = NULL,
  hourly.dose = 1/24,
  concentration = "plasma",
  suppress.messages = FALSE,
  recalc.blood2plasma = FALSE,
  tissue = NULL,
  restrictive.clearance = TRUE,
  bioactive.free.invivo = FALSE,
  Caco2.options = list(),
  ...
)
}
\arguments{
\item{chem.name}{Either the chemical name, CAS number, or the parameters must 
be specified.}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must 
be specified.}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Chemical parameters from parameterize_pbtk (for model = 
'pbtk'), parameterize_3comp (for model = '3compartment), 
parameterize_1comp(for model = '1compartment') or parameterize_steadystate 
(for model = '3compartmentss'), overrides chem.name and chem.cas.}

\item{hourly.dose}{Hourly dose rate mg/kg BW/h.}

\item{concentration}{Desired concentration type, 'blood' or default 'plasma'.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{recalc.blood2plasma}{Recalculates the ratio of the amount of chemical 
in the blood to plasma using the input parameters. Use this if you have 
altered hematocrit, Funbound.plasma, or Krbc2pu.}

\item{tissue}{Desired tissue conentration (defaults to whole body 
concentration.)}

\item{restrictive.clearance}{If TRUE (default), then only the fraction of
chemical not bound to protein is available for metabolism in the liver. If 
FALSE, then all chemical in the liver is metabolized (faster metabolism due
to rapid off-binding).}

\item{bioactive.free.invivo}{If FALSE (default), then the total concentration is treated
as bioactive in vivo. If TRUE, the the unbound (free) plasma concentration is treated as 
bioactive in vivo. Only works with tissue = NULL in current implementation.}

\item{Caco2.options}{A list of options to use when working with Caco2 apical to
basolateral data \code{Caco2.Pab}, default is Caco2.options = list(Caco2.Pab.default = 1.6,
Caco2.Fabs = TRUE, Caco2.Fgut = TRUE, overwrite.invivo = FALSE, keepit100 = FALSE). Caco2.Pab.default sets the default value for 
Caco2.Pab if Caco2.Pab is unavailable. Caco2.Fabs = TRUE uses Caco2.Pab to calculate
fabs.oral, otherwise fabs.oral = \code{Fabs}. Caco2.Fgut = TRUE uses Caco2.Pab to calculate 
fgut.oral, otherwise fgut.oral = \code{Fgut}. overwrite.invivo = TRUE overwrites Fabs and Fgut in vivo values from literature with 
Caco2 derived values if available. keepit100 = TRUE overwrites Fabs and Fgut with 1 (i.e. 100 percent) regardless of other settings.
See \code{\link{get_fabsgut}} for further details.}

\item{...}{Additional parameters passed to parameterize function if 
parameters is NULL.}
}
\value{
Steady state plasma concentration in mg/L units
}
\description{
This function calculates the analytic steady state plasma or venous blood 
concentrations as a result of infusion dosing.
}
\seealso{
\code{\link{calc_analytic_css}}

\code{\link{parameterize_1comp}}
}
\author{
Robert Pearce and John Wambaugh
}
\keyword{1compartment}
