% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_units.R
\name{convert_units}
\alias{convert_units}
\title{convert_units}
\usage{
convert_units(
  input.units = NULL,
  output.units = NULL,
  MW = NULL,
  vol = NULL,
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  temp = 25,
  liquid.density = 1,
  state = "liquid"
)
}
\arguments{
\item{input.units}{Assigned input units of interest}

\item{output.units}{Desired output units}

\item{MW}{Molecular weight of substance of interest in g/mole}

\item{vol}{Volume for the target tissue of interest in liters (L).
NOTE: Volume should not be in units of per BW, i.e. "kg".}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must
be specified.}

\item{chem.name}{Either the chemical name, CAS number, or the parameters
must be specified.}

\item{dtxsid}{EPA's DSSTox Structure ID 
(\url{https://comptox.epa.gov/dashboard}) the chemical must be identified by
either CAS, name, or DTXSIDs}

\item{parameters}{A set of model parameters, especially a set that
includes MW (molecular weight) for our conversions}

\item{temp}{Temperature for conversions (default = 25 degreees C)}

\item{liquid.density}{Density of the specified chemical in liquid state,
numeric value, (default 1.0 g/mL).}

\item{state}{Chemical state (gas or default liquid).}
}
\description{
This function is designed to accept input units, output units, and the 
molecular weight (MW) of a substance of interest to then use a table lookup
to return a scaling factor that can be readily applied for the intended
conversion. It can also take chemical identifiers in the place of a 
specified molecular weight value to retrieve that value for its own use.
}
\details{
If input or output units not contained in the table are queried,
it gives a corresponding error message. It gives a warning message about the
handling of 'ppmv,' as the function is only set up to convert between ppmv 
and mass-based units (like 
mg/\ifelse{html}{\out{m<sup>3</sup>}}{\eqn{m^3}} or umol/L) 
in the context of ideal gases.

convert_units is not directly configured to accept and convert units based
on BW, like mg/kg. For this purpose, see \code{\link{scale_dosing}}.

The function supports a limited set of most relevant units across
toxicological models, currently including umol, uM, mg, mg/L, 
mg/\ifelse{html}{\out{m<sup>3</sup>}}{\eqn{m^3}} or umol/L), and
in the context of gases assumed to be ideal, ppmv. 

\emph{Andersen and Clewell's Rules of PBPK Modeling:}
\enumerate{
\item Check Your Units
\item \strong{Check Your Units}
\item Check Mass Balance
}
}
\examples{

# MW BPA is 228.29 g/mol
# 1 mg/L -> 1/228.29*1000 = 4.38 uM
convert_units("mg/L","uM",chem.cas="80-05-7")

# MW Diclofenac is 296.148 g/mol
# 1 uM -> 296.148/1000 =  0.296
convert_units("uM","mg/L",chem.name="diclofenac")

convert_units("uM","ppmv",chem.name="styrene")

# Compare with https://www3.epa.gov/ceampubl/learn2model/part-two/onsite/ia_unit_conversion.html
# 1 ug/L Toluene -> 0.263 ppmv
convert_units("ug/L","ppmv",chem.name="toluene")
# 1 pppmv Toluene, 0.0038 mg/L
convert_units("ppmv","mg/L",chem.name="toluene")

MW_pyrene <- get_physchem_param(param='MW', chem.name='pyrene')
conversion_factor <- convert_units(input.units='mg/L', output.units ='uM',
  MW=MW_pyrene)

calc_mc_oral_equiv(15, parameters=p)
}
\author{
Mark Sfeir, John Wambaugh, and Sarah E. Davidson
}
