% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_chemtable.R
\name{add_chemtable}
\alias{add_chemtable}
\title{Add a table of chemical information for use in making httk predictions.}
\usage{
add_chemtable(
  new.table,
  data.list,
  current.table = NULL,
  reference = NULL,
  species = NULL,
  overwrite = FALSE,
  sig.fig = 4,
  clint.pvalue.overwrite = TRUE,
  allow.na = FALSE
)
}
\arguments{
\item{new.table}{Object of class data.frame containing one row per chemical,
with each chemical minimally described by a CAS number.}

\item{data.list}{This list identifies which properties are to be read from
the table. Each item in the list should point to a column in the table
new.table. Valid names in the list are: 'Compound', 'CAS', 'DSSTox.GSID'
'SMILES.desalt', 'Reference', 'Species', 'MW', 'logP', 'pKa_Donor',
'pKa_Accept', 'logMA', 'Clint', 'Clint.pValue', 'Funbound.plasma',
'Fgutabs', 'Rblood2plasma'.}

\item{current.table}{This is the table to which data are being added.}

\item{reference}{This is the reference for the data in the new table. This
may be omitted if a column in data.list gives the reference value for each
chemical.}

\item{species}{This is the species for the data in the new table. This may
be omitted if a column in data.list gives the species value for each
chemical or if the data are not species-specific (e.g., MW).}

\item{overwrite}{If overwrite=TRUE then data in current.table will be
replaced by any data in new.table that is for the same chemical and
property. If overwrite=FALSE (DEFAULT) then new data for the same chemical
and property are ignored.  Funbound.plasma values of 0 (below limit of
detection) are overwritten either way.}

\item{sig.fig}{Sets the number of significant figures stored (defaults to 4)}

\item{clint.pvalue.overwrite}{If TRUE then the Cl_int p-value is set to NA 
when the Cl_int value is changed unless a new p-value is provided. (defaults
to TRUE)}

\item{allow.na}{If TRUE (default is FALSE) then NA values are written to the
table, otherwise they are ignored.}
}
\value{
\item{data.frame}{A new data.frame containing the data in
current.table augmented by new.table}
}
\description{
This function adds chemical-specific information to the table
chem.physical_and_invitro.data. This table is queried by the model
parameterization functions when attempting to parameterize a model, so
adding sufficient data to this table allows additional chemicals to be
modeled.
}
\examples{

\donttest{
my.new.data <- as.data.frame(c("A","B","C"),stringsAsFactors=FALSE)
my.new.data <- cbind(my.new.data,as.data.frame(c("111-11-2","222-22-0","333-33-5"),
                     stringsAsFactors=FALSE))
my.new.data <- cbind(my.new.data,as.data.frame(c("DTX1","DTX2","DTX3"),
                    stringsAsFactors=FALSE))
my.new.data <- cbind(my.new.data,as.data.frame(c(200,200,200)))
my.new.data <- cbind(my.new.data,as.data.frame(c(2,3,4)))
my.new.data <- cbind(my.new.data,as.data.frame(c(0.01,0.02,0.3)))
my.new.data <- cbind(my.new.data,as.data.frame(c(0,10,100)))
colnames(my.new.data) <- c("Name","CASRN","DTXSID","MW","LogP","Fup","CLint")

chem.physical_and_invitro.data <- add_chemtable(my.new.data,
                                  current.table=chem.physical_and_invitro.data,
                                  data.list=list(
                                  Compound="Name",
                                  CAS="CASRN",
                                  DTXSID="DTXSID",
                                  MW="MW",
                                  logP="LogP",
                                  Funbound.plasma="Fup",
                                  Clint="CLint"),
                                  species="Human",
                                  reference="MyPaper 2015")
parameterize_steadystate(chem.name="C")  
calc_css(chem.name="B")                                
}

}
\author{
John Wambaugh
}
