% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_linear_hypothesis.R
\name{mc_linear_hypothesis}
\alias{mc_linear_hypothesis}
\title{Test Linear Hypothesis}
\usage{
mc_linear_hypothesis(object, hypothesis, verbose = TRUE)
}
\arguments{
\item{object}{An object of \code{mcglm} class.}

\item{hypothesis}{A vector of strings with the hypotheses to be
tested.}

\item{verbose}{a logical if TRUE print some information about the
tests performed. Default verbose = TRUE.}
}
\value{
Table result of the hypothesis test specified.
}
\description{
Performs Wald tests for testing a linear hypothesis for
model objects produced by mcglm.
}
\examples{

library(mcglm)
library(Matrix)
library(htmcglm)

data("soya", package = "mcglm")

form.grain <- grain ~ water * pot
form.seed <- seeds ~ water * pot

soya$viablepeasP <- soya$viablepeas / soya$totalpeas
form.peas <- viablepeasP ~ water * pot

Z0 <- mc_id(soya)
Z1 <- mc_mixed(~0 + factor(block), data = soya)

fit_joint <- mcglm(linear_pred = c(form.grain,
                                   form.seed,
                                   form.peas),
                   matrix_pred = list(c(Z0, Z1),
                                      c(Z0, Z1),
                                      c(Z0, Z1)),
                   link = c("identity",
                            "log",
                            "logit"),
                   variance = c("constant",
                                "tweedie",
                                "binomialP"),
                   Ntrial = list(NULL,
                                 NULL,
                                 soya$totalpeas),
                   power_fixed = c(TRUE,TRUE,TRUE),
                   data = soya)

mc_linear_hypothesis(object =  fit_joint,
                     hypothesis = c('beta11 = 0'))

mc_linear_hypothesis(object =  fit_joint,
                     hypothesis = c('beta11 = 0',
                                    'beta12 = 0'))

mc_linear_hypothesis(object =  fit_joint,
                     hypothesis = c('beta11 = 0',
                                    'beta12 = 0',
                                    'beta21 = 0',
                                    'beta22 = 0',
                                    'beta31 = 0',
                                    'beta32 = 0'))

mc_linear_hypothesis(object =  fit_joint,
                     hypothesis = c('beta11 = beta21'))

mc_linear_hypothesis(object =  fit_joint,
                     hypothesis = c('tau11 = 0'))

mc_linear_hypothesis(object =  fit_joint,
                     hypothesis = c('tau11 = 0',
                                    'tau21 = 0',
                                    'tau31 = 0'))

mc_linear_hypothesis(object =  fit_joint,
                     hypothesis = c('tau12 = tau22'))
}
\author{
Lineu Alberto Cavazani de Freitas,
\email{lineuacf@gmail.com}
}
