% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apc.R
\name{apc}
\alias{apc}
\title{Generate Matrix of All Pairwise Comparisons (Tukey contrasts)}
\usage{
apc(lfm, lev = NULL)
}
\arguments{
\item{lfm}{a \eqn{k \times p} matrix where each line defines a linear
function to estimate a lsmean. In general, these matrices are
obtained by using doBy::LSmatrix().}

\item{lev}{a character vector with length equals to the numbers of
lines of \code{lfm} matrix, (\eqn{k}). Default is \code{NULL} and
the row names of code{lfm} is used. If row names is also
\code{NULL}, incremental integer values are used to identify the
comparisons.}
}
\value{
a \eqn{K\times p} matrix with the linear functions that
define all pairwise contrasts. \eqn{K} is \eqn{{k}\choose{2}}.
}
\description{
This function takes a matrix where each line defines a
linear function of the parameters to estimate a marginal mean
(aka least squares mean) and return the matrix that define the
contrasts among these means. All pairwise contrasts are returned
(aka Tukey contrasts). The matrix with these contrasts can be
passed to glht::multcomp() to estimate them or used
in explicit matricial calculus.
}
\examples{

X <- diag(3)
rownames(X)
apc(X)

rownames(X) <- letters[nrow(X):1]
apc(X)

apc(X, lev = LETTERS[1:nrow(X)])

# Objects from doBy::LSmatrix() have an "grid" attribute.
attr(X, "grid") <- data.frame(n = LETTERS[1:nrow(X)])
rownames(X) <- NULL
apc(X)

}
\seealso{
doBy::LSmatrix().
}
\author{
Walmes Zeviani, \email{walmes@ufpr.br}.
}
