% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htm2txt.R
\name{htm2txt}
\alias{htm2txt}
\title{Convert a html document to simple plain texts by removing all html tags}
\usage{
htm2txt(htm, list = "\\n&#8226; ", pagebreak = "\\n\\n----------\\n\\n")
}
\arguments{
\item{htm}{A character vector, containing a html document, to be converted into plain texts (other objects are coerced into character vectors).}

\item{list}{A character that replaces a <li>...</li> tag (referring to a numbering or bullet for lists).}

\item{pagebreak}{A character that replaces a <hr> tag (referring to a thematic change in the content or a page break).}
}
\value{
A character vector containing plain texts converted from the html document.
}
\description{
Convert a html document to simple plain texts by removing all html tags
}
\examples{
text = htm2txt("<html><body>html texts</body></html>")
text = htm2txt(c("Hello<p>World", "Goodbye<br>Friends"))
text = htm2txt("<p>Menu:</p><ul></li>Coffee</li><li>Tea</li></ul>", list = "\\n- ")
text = htm2txt("Page 1<hr>Page 2", pagebreak = "\\n\\n[NEW PAGE]\\n\\n")
}
