% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{multivariate_grid}
\alias{multivariate_grid}
\title{Multivariate Grid}
\usage{
multivariate_grid(
  x,
  grid_size = 49L,
  trim = c(0.01, 0.99),
  strategy = c("uniform", "quantile")
)
}
\arguments{
\item{x}{A vector, matrix, or data.frame to turn into a grid of values.}

\item{grid_size}{Controls the approximate grid size. If \code{x} has p columns, then each
(non-discrete) column will be reduced to about the p-th root of \code{grid_size} values.}

\item{trim}{A non-discrete numeric variable is trimmed at these quantile
probabilities before calculations. Set to \code{c(0, 1)} for no trimming.}

\item{strategy}{How to find evaluation points of non-discrete numeric columns?
Either "uniform" (via \code{\link[=pretty]{pretty()}}) or "quantile", see description of
\code{\link[=univariate_grid]{univariate_grid()}}.}
}
\value{
A vector, matrix, or data.frame with evaluation points.
}
\description{
This function creates a multivariate grid. Each column of the input \code{x} is turned
(independently) into a vector of grid values via \code{\link[=univariate_grid]{univariate_grid()}}.
Combinations are then formed by calling \code{\link[=expand.grid]{expand.grid()}}.
}
\examples{
multivariate_grid(iris[1:2], grid_size = 4)
multivariate_grid(iris$Species)  # Works also in the univariate case
}
\seealso{
\code{\link[=univariate_grid]{univariate_grid()}}
}
