% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h2.R
\name{h2}
\alias{h2}
\alias{h2.default}
\alias{h2.hstats}
\title{Total Interaction Strength}
\usage{
h2(object, ...)

\method{h2}{default}(object, ...)

\method{h2}{hstats}(object, normalize = TRUE, squared = TRUE, eps = 1e-08, ...)
}
\arguments{
\item{object}{Object of class "hstats".}

\item{...}{Currently unused.}

\item{normalize}{Should statistic be normalized? Default is \code{TRUE}.}

\item{squared}{Should \emph{squared} statistics be returned? Default is \code{TRUE}.}

\item{eps}{Threshold below which numerator values are set to 0.}
}
\value{
Vector of total interaction strength (one value per prediction dimension).
}
\description{
Proportion of prediction variability unexplained by main effects of \code{v}, see Details.
}
\details{
If the model is additive in all features, then the (centered) prediction
function \eqn{F} equals the sum of the (centered) partial dependence
functions \eqn{F_j(x_j)}, i.e.,
\deqn{
  F(\mathbf{x}) = \sum_{j}^{p} F_j(x_j)
}
(check \code{\link[=partial_dep]{partial_dep()}} for all definitions).
To measure the relative amount of variability unexplained by all main effects,
we can therefore study the test statistic of total interaction strength
\deqn{
  H^2 = \frac{\frac{1}{n} \sum_{i = 1}^n \big[F(\mathbf{x}_i) - 
  \sum_{j = 1}^p\hat F_j(x_{ij})\big]^2}{\frac{1}{n} 
  \sum_{i = 1}^n\big[F(\mathbf{x}_i)\big]^2}.
}
A value of 0 means there are no interaction effects at all.
Due to (typically undesired) extrapolation effects, depending on the model,
values above 1 may occur.

In Żółkowski et al. (2023), \eqn{1 - H^2} is called \emph{additivity index}.
A similar measure using accumulated local effects is discussed in Molnar (2020).
}
\section{Methods (by class)}{
\itemize{
\item \code{h2(default)}: Default method of total interaction strength.

\item \code{h2(hstats)}: Total interaction strength from "interact" object.

}}
\examples{
# MODEL 1: Linear regression
fit <- lm(Sepal.Length ~ . + Petal.Width:Species, data = iris)
s <- hstats(fit, v = names(iris[-1]), X = iris, verbose = FALSE)
h2(s)

# MODEL 2: Multi-response linear regression
fit <- lm(as.matrix(iris[1:2]) ~ Petal.Length + Petal.Width * Species, data = iris)
v <- c("Petal.Length", "Petal.Width", "Species")
s <- hstats(fit, v = v, X = iris, verbose = FALSE)
h2(s)

# MODEL 3: No interactions
fit <- lm(Sepal.Length ~ ., data = iris)
s <- hstats(fit, v = names(iris[-1]), X = iris, verbose = FALSE)
h2(s)
}
\references{
\enumerate{
\item Żółkowski, Artur, Mateusz Krzyziński, and Paweł Fijałkowski.
\emph{Methods for extraction of interactions from predictive models.}
Undergraduate thesis. Faculty of Mathematics and Information Science,
Warsaw University of Technology (2023).
\item Molnar, Christoph, Giuseppe Casalicchio, and Bernd Bischl".
\emph{Quantifying Model Complexity via Functional Decomposition for Better Post-hoc Interpretability},
in Machine Learning and Knowledge Discovery in Databases,
Springer International Publishing (2020): 193-204.
}
}
\seealso{
\code{\link[=hstats]{hstats()}}, \code{\link[=h2_overall]{h2_overall()}}, \code{\link[=h2_pairwise]{h2_pairwise()}}, \code{\link[=h2_threeway]{h2_threeway()}}
}
