% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.R
\name{swap.out.alt.ids}
\alias{swap.out.alt.ids}
\title{Remove alternate/deprecated HPO term IDs and swap for new ones}
\usage{
swap.out.alt.ids(hpo.terms, terms, remove.dead = FALSE)
}
\arguments{
\item{hpo.terms}{R-Object representation of HPO}

\item{terms}{Character vector of HPO terms}

\item{remove.dead}{Boolean to indicate whether to strip out terms which can't be found in the given hpo.terms database argument}
}
\value{
A directed adjacency matrix of \code{terms} based on DAG structure of HPO, whereby each term is considered adjacent to it's MRCA in \code{terms}
}
\description{
Remove alternate/deprecated HPO term IDs and swap for new ones
}
\examples{
data(hpo.terms)
swap.out.alt.ids(hpo.terms, c("HP:0001873"))
}

