% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/graphs.R
\name{get.pop.frequency.based.colours}
\alias{get.pop.frequency.based.colours}
\title{Function to colour HPO nodes in plot with colours based on information content/frequency of terms with respect to population}
\usage{
get.pop.frequency.based.colours(hpo.terms, terms, plotting.context,
  colourPalette = colorRampPalette(c("Yellow", "Green", "#0099FF"))(10),
  terms.freq = if (is.null(plotting.context$frequency))
  exp(-plotting.context$information[terms]) else plotting.context$frequency,
  max.colour.freq = max(terms.freq), min.colour.freq = min(terms.freq))
}
\arguments{
\item{hpo.terms}{R-Object representation of HPO}

\item{terms}{Character vector of HPO terms}

\item{plotting.context}{List object with hpo.phenotypes slot for list of character vectors of terms}

\item{colourPalette}{Character vector of colours for the different information contents of the terms to be plotted, going from rare to common}

\item{terms.freq}{Numeric vector of frequencies of terms in plot, named by term}

\item{max.colour.freq}{Numeric value in [0, 1] giving the maximum frequency (to which the dullest color will be assigned)}

\item{min.colour.freq}{Numeric value in [0, 1] giving the minimum frequency (to which the brightest color will be assigned)}
}
\value{
Character vector of colours, named by term
}
\description{
Function to colour HPO nodes in plot with colours based on information content/frequency of terms with respect to population
}

