% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plot.serieshpi}
\alias{plot.serieshpi}
\title{Plot method for `serieshpi` object}
\usage{
\method{plot}{serieshpi}(x, smooth = FALSE, ...)
}
\arguments{
\item{x}{Object of class `serieshpi`}

\item{smooth}{default = FALSE; plot the smoothed object}

\item{...}{Additional Arguments`}
}
\value{
`plotseries` object inheriting from a ggplot object
}
\description{
Specific plotting method for serieshpi objects
}
\examples{

 # Load data
 data(ex_sales)

 # Create index
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

 # Create Series (Suppressing messages do to small sample size of this example)
 suppressMessages(
   hpi_series <- createSeries(hpi_obj = rt_index,
                              train_period = 12))

 # Make Plot
 plot(hpi_series)

}
