# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

bijectionvector <- function(K) {
    .Call(`_hmcdm_bijectionvector`, K)
}

#' @title Convert integer to attribute pattern
#' @description Based on the bijective relationship between natural numbers and sum of powers of two,
#'  convert integer between 0 and 2^K-1 to K-dimensional attribute pattern.
#' @param K An \code{int} for the number of attributes
#' @param CL An \code{int} between 0 and 2^K-1
#' @return A \code{vec} of the K-dimensional attribute pattern corresponding to CL.
#' @examples
#' inv_bijectionvector(4,0)
#' @export
inv_bijectionvector <- function(K, CL) {
    .Call(`_hmcdm_inv_bijectionvector`, K, CL)
}

rwishart <- function(df, S) {
    .Call(`_hmcdm_rwishart`, df, S)
}

rinvwish <- function(df, Sig) {
    .Call(`_hmcdm_rinvwish`, df, Sig)
}

rmultinomial <- function(ps) {
    .Call(`_hmcdm_rmultinomial`, ps)
}

rDirichlet <- function(deltas) {
    .Call(`_hmcdm_rDirichlet`, deltas)
}

dmvnrm <- function(x, mean, sigma, logd = FALSE) {
    .Call(`_hmcdm_dmvnrm`, x, mean, sigma, logd)
}

rmvnrm <- function(mu, sigma) {
    .Call(`_hmcdm_rmvnrm`, mu, sigma)
}

#' @title Generate random Q matrix
#' @description Creates a random Q matrix containing three identity matrices after row permutation
#' @param J An \code{int} that represents the number of items
#' @param K An \code{int} that represents the number of attributes/skills
#' @return A dichotomous \code{matrix} for Q.
#' @examples 
#' random_Q(15,4)
#' @export
random_Q <- function(J, K) {
    .Call(`_hmcdm_random_Q`, J, K)
}

#' @title Generate ideal response matrix
#' @description Based on the Q matrix and the latent attribute space, generate the ideal response matrix for each skill pattern
#' @param K An \code{int} of the number of attributes
#' @param J An \code{int} of the number of items
#' @param Q A J-by-K Q \code{matrix}
#' @return A J-by-2^K ideal response \code{matrix}
#' @examples 
#' Q = random_Q(15,4)
#' ETA = ETAmat(4,15,Q)
#' @export
ETAmat <- function(K, J, Q) {
    .Call(`_hmcdm_ETAmat`, K, J, Q)
}

#' @title Generate monotonicity matrix
#' @description Based on the latent attribute space, generate a matrix indicating whether it is possible to
#' transition from pattern cc to cc' under the monotonicity learning assumption.
#' @param K An \code{int} of the number of attributes.
#' @return A 2^K-by-2^K dichotomous \code{matrix} of whether it is possible to transition between two patterns 
#' @examples
#' TP = TPmat(4)
#' @export
TPmat <- function(K) {
    .Call(`_hmcdm_TPmat`, K)
}

crosstab <- function(V1, V2, TP, nClass, col_dim) {
    .Call(`_hmcdm_crosstab`, V1, V2, TP, nClass, col_dim)
}

resp_miss <- function(Responses, Test_order, Test_versions) {
    .Call(`_hmcdm_resp_miss`, Responses, Test_order, Test_versions)
}

#' @title Compute item pairwise odds ratio
#' @description Based on a response matrix, calculate the item pairwise odds-ratio according do (n11*n00)/(n10*n01), where nij is the
#' number of people answering both item i and item j correctly
#' @param N An \code{int} of the sample size
#' @param J An \code{int} of the number of items
#' @param Yt An N-by-J response \code{matrix}
#' @return A J-by-J upper-triangular \code{matrix} of the item pairwise odds ratios
#' @examples 
#' \donttest{
#' N = length(Test_versions)
#' J = nrow(Q_matrix)
#' K = ncol(Q_matrix)
#' L = nrow(Test_order)
#' Jt = J/L
#' OddsRatio(N,J,Y_real_array[,,1])}
#' @export
OddsRatio <- function(N, J, Yt) {
    .Call(`_hmcdm_OddsRatio`, N, J, Yt)
}

getMode <- function(sorted_vec, size) {
    .Call(`_hmcdm_getMode`, sorted_vec, size)
}

Sparse2Dense <- function(Y_real_array, Test_order, Test_versions) {
    .Call(`_hmcdm_Sparse2Dense`, Y_real_array, Test_order, Test_versions)
}

Dense2Sparse <- function(Y_sim, Test_order, Test_versions) {
    .Call(`_hmcdm_Dense2Sparse`, Y_sim, Test_order, Test_versions)
}

Mat2Array <- function(Q_matrix, T) {
    .Call(`_hmcdm_Mat2Array`, Q_matrix, T)
}

Array2Mat <- function(r_stars) {
    .Call(`_hmcdm_Array2Mat`, r_stars)
}

#' @title Generate a list of Q-matrices for each examinee.
#' @description Generate a list of length N. Each element of the list is a JxK Q_matrix of all items
#' administered across all time points to the examinee, in the order of administration.
#' @param Q_matrix A J-by-K matrix, indicating the item-skill relationship.
#' @param Test_order A TxT matrix, each row is the order of item blocks for that test version.
#' @param Test_versions A vector of length N, containing each subject's test version.
#' @return A list of length N. Each element of the list is a JxK matrix.
#' @examples 
#' \donttest{
#' Q_examinee = Q_list(Q_matrix, Test_order, Test_versions)}
#' @export
Q_list <- function(Q_matrix, Test_order, Test_versions) {
    .Call(`_hmcdm_Q_list`, Q_matrix, Test_order, Test_versions)
}

point_estimates_learning <- function(output, model, N, Jt, K, T, alpha_EAP = TRUE) {
    .Call(`_hmcdm_point_estimates_learning`, output, model, N, Jt, K, T, alpha_EAP)
}

Learning_fit <- function(output, model, Y_real_array, Q_matrix, Test_order, Test_versions, Q_examinee = NULL, Latency_array = NULL, G_version = NA_integer_, R = NULL) {
    .Call(`_hmcdm_Learning_fit`, output, model, Y_real_array, Q_matrix, Test_order, Test_versions, Q_examinee, Latency_array, G_version, R)
}

parm_update_HO <- function(N, Jt, K, T, alphas, pi, lambdas, thetas, response, itempars, Qs, Q_examinee, Test_order, Test_versions, theta_propose, deltas_propose) {
    .Call(`_hmcdm_parm_update_HO`, N, Jt, K, T, alphas, pi, lambdas, thetas, response, itempars, Qs, Q_examinee, Test_order, Test_versions, theta_propose, deltas_propose)
}

Gibbs_DINA_HO <- function(Response, Qs, Test_order, Test_versions, theta_propose, deltas_propose, chain_length, burn_in) {
    .Call(`_hmcdm_Gibbs_DINA_HO`, Response, Qs, Test_order, Test_versions, theta_propose, deltas_propose, chain_length, burn_in)
}

parm_update_HO_RT_sep <- function(N, Jt, K, T, alphas, pi, lambdas, thetas, latency, RT_itempars, taus, phi_vec, tauvar, response, itempars, Qs, Q_examinee, Test_order, Test_versions, G_version, theta_propose, a_sigma_tau0, rate_sigma_tau0, deltas_propose, a_alpha0, rate_alpha0) {
    .Call(`_hmcdm_parm_update_HO_RT_sep`, N, Jt, K, T, alphas, pi, lambdas, thetas, latency, RT_itempars, taus, phi_vec, tauvar, response, itempars, Qs, Q_examinee, Test_order, Test_versions, G_version, theta_propose, a_sigma_tau0, rate_sigma_tau0, deltas_propose, a_alpha0, rate_alpha0)
}

Gibbs_DINA_HO_RT_sep <- function(Response, Latency, Qs, Test_order, Test_versions, G_version, theta_propose, deltas_propose, chain_length, burn_in) {
    .Call(`_hmcdm_Gibbs_DINA_HO_RT_sep`, Response, Latency, Qs, Test_order, Test_versions, G_version, theta_propose, deltas_propose, chain_length, burn_in)
}

parm_update_HO_RT_joint <- function(N, Jt, K, T, alphas, pi, lambdas, thetas, latency, RT_itempars, taus, phi_vec, Sig, response, itempars, Qs, Q_examinee, Test_order, Test_versions, G_version, sig_theta_propose, S, p, deltas_propose, a_alpha0, rate_alpha0) {
    .Call(`_hmcdm_parm_update_HO_RT_joint`, N, Jt, K, T, alphas, pi, lambdas, thetas, latency, RT_itempars, taus, phi_vec, Sig, response, itempars, Qs, Q_examinee, Test_order, Test_versions, G_version, sig_theta_propose, S, p, deltas_propose, a_alpha0, rate_alpha0)
}

Gibbs_DINA_HO_RT_joint <- function(Response, Latency, Qs, Test_order, Test_versions, G_version, sig_theta_propose, deltas_propose, chain_length, burn_in) {
    .Call(`_hmcdm_Gibbs_DINA_HO_RT_joint`, Response, Latency, Qs, Test_order, Test_versions, G_version, sig_theta_propose, deltas_propose, chain_length, burn_in)
}

parm_update_rRUM <- function(N, Jt, K, T, alphas, pi, taus, R, r_stars, pi_stars, Qs, responses, X_ijk, Smats, Gmats, Test_order, Test_versions, dirich_prior) {
    invisible(.Call(`_hmcdm_parm_update_rRUM`, N, Jt, K, T, alphas, pi, taus, R, r_stars, pi_stars, Qs, responses, X_ijk, Smats, Gmats, Test_order, Test_versions, dirich_prior))
}

Gibbs_rRUM_indept <- function(Response, Qs, R, Test_order, Test_versions, chain_length, burn_in) {
    .Call(`_hmcdm_Gibbs_rRUM_indept`, Response, Qs, R, Test_order, Test_versions, chain_length, burn_in)
}

parm_update_NIDA_indept <- function(N, Jt, K, T, alphas, pi, taus, R, Qs, responses, X_ijk, Smats, Gmats, Test_order, Test_versions, dirich_prior) {
    invisible(.Call(`_hmcdm_parm_update_NIDA_indept`, N, Jt, K, T, alphas, pi, taus, R, Qs, responses, X_ijk, Smats, Gmats, Test_order, Test_versions, dirich_prior))
}

Gibbs_NIDA_indept <- function(Response, Qs, R, Test_order, Test_versions, chain_length, burn_in) {
    .Call(`_hmcdm_Gibbs_NIDA_indept`, Response, Qs, R, Test_order, Test_versions, chain_length, burn_in)
}

parm_update_DINA_FOHM <- function(N, J, K, nClass, nT, Y, TP, ETA, ss, gs, CLASS, pi, Omega) {
    invisible(.Call(`_hmcdm_parm_update_DINA_FOHM`, N, J, K, nClass, nT, Y, TP, ETA, ss, gs, CLASS, pi, Omega))
}

Gibbs_DINA_FOHM <- function(Response, Qs, Test_order, Test_versions, chain_length, burn_in) {
    .Call(`_hmcdm_Gibbs_DINA_FOHM`, Response, Qs, Test_order, Test_versions, chain_length, burn_in)
}

#' @title Gibbs sampler for learning models
#' @description Runs MCMC to estimate parameters of any of the listed learning models. 
#' @param Y_real_array An \code{array} of dichotomous item responses. t-th slice is an N-by-J matrix of responses at time t.
#' @param Q_matrix A J-by-K Q-matrix. 
#' @param model A \code{charactor} of the type of model fitted with the MCMC sampler, possible selections are 
#' "DINA_HO": Higher-Order Hidden Markov Diagnostic Classification Model with DINA responses;
#' "DINA_HO_RT_joint": Higher-Order Hidden Markov DCM with DINA responses, log-Normal response times, and joint modeling of latent
#' speed and learning ability; 
#' "DINA_HO_RT_sep": Higher-Order Hidden Markov DCM with DINA responses, log-Normal response times, and separate modeling of latent
#' speed and learning ability; 
#' "rRUM_indept": Simple independent transition probability model with rRUM responses
#' "NIDA_indept": Simple independent transition probability model with NIDA responses
#' "DINA_FOHM": First Order Hidden Markov model with DINA responses
#' @param Test_order A \code{matrix} of the order of item blocks for each test version.
#' @param Test_versions A \code{vector} of the test version of each learner.
#' @param chain_length An \code{int} of the MCMC chain length.
#' @param burn_in An \code{int} of the MCMC burn-in chain length.
#' @param Latency_array Optional. A \code{array} of the response times. t-th slice is an N-by-J matrix of response times at time t.
#' @param G_version Optional. An \code{int} of the type of covariate for increased fluency (1: G is dichotomous depending on whether all skills required for
#' current item are mastered; 2: G cumulates practice effect on previous items using mastered skills; 3: G is a time block effect invariant across 
#' subjects with different attribute trajectories)
#' @param theta_propose Optional. A \code{scalar} for the standard deviation of theta's proposal distribution in the MH sampling step.
#' @param deltas_propose Optional. A \code{vector} for the band widths of each lambda's proposal distribution in the MH sampling step.
#' @param R Optional. A reachability \code{matrix} for the hierarchical relationship between attributes. 
#' @return A \code{list} of parameter samples and Metropolis-Hastings acceptance rates (if applicable).
#' @author Susu Zhang
#' @examples
#' \donttest{
#' output_FOHM = hmcdm(Y_real_array,Q_matrix,"DINA_FOHM",Test_order,Test_versions,100,30)
#' }
#' @export
hmcdm <- function(Y_real_array, Q_matrix, model, Test_order, Test_versions, chain_length, burn_in, G_version = NA_integer_, theta_propose = 0., Latency_array = NULL, deltas_propose = NULL, R = NULL) {
    .Call(`_hmcdm_hmcdm`, Y_real_array, Q_matrix, model, Test_order, Test_versions, chain_length, burn_in, G_version, theta_propose, Latency_array, deltas_propose, R)
}

sim_resp_DINA <- function(J, K, ETA, Svec, Gvec, alpha) {
    .Call(`_hmcdm_sim_resp_DINA`, J, K, ETA, Svec, Gvec, alpha)
}

#' @title Simulate DINA model responses (entire cube)
#' @description Simulate a cube of DINA responses for all persons on items across all time points
#' @param alphas An N-by-K-by-L \code{array} of attribute patterns of all persons across L time points 
#' @param itempars A J-by-2-by-L \code{cube} of item parameters (slipping: 1st col, guessing: 2nd col) across item blocks
#' @param ETA A J-by-2^K-by-L \code{array} of ideal responses across all item blocks, with each slice generated with ETAmat function
#' @param Test_order A N_versions-by-L \code{matrix} indicating which block of items were administered to examinees with specific test version.
#' @param Test_versions A length N \code{vector} of the test version of each examinee
#' @return An \code{array} of DINA item responses of examinees across all time points
#' @examples
#' N = length(Test_versions)
#' J = nrow(Q_matrix)
#' K = ncol(Q_matrix)
#' L = nrow(Test_order)
#' Jt = J/L
#' itempars_true <- array(runif(Jt*2*L,.1,.2), dim = c(Jt,2,L))
#' 
#' ETAs <- ETAmat(K,J,Q_matrix)
#' class_0 <- sample(1:2^K, N, replace = L)
#' Alphas_0 <- matrix(0,N,K)
#' mu_thetatau = c(0,0)
#' Sig_thetatau = rbind(c(1.8^2,.4*.5*1.8),c(.4*.5*1.8,.25))
#' Z = matrix(rnorm(N*2),N,2)
#' thetatau_true = Z%*%chol(Sig_thetatau)
#' thetas_true = thetatau_true[,1]
#' taus_true = thetatau_true[,2]
#' G_version = 3
#' phi_true = 0.8
#' for(i in 1:N){
#'   Alphas_0[i,] <- inv_bijectionvector(K,(class_0[i]-1))
#' }
#' lambdas_true <- c(-2, .4, .055)
#' Q_examinee <- Q_list(Q_matrix, Test_order, Test_versions)     
#' Alphas <- simulate_alphas_HO_joint(lambdas_true,thetas_true,Alphas_0,Q_examinee,L,Jt)
#' Y_sim <- simDINA(Alphas,itempars_true,ETAs,Test_order,Test_versions)
#' @export
simDINA <- function(alphas, itempars, ETA, Test_order, Test_versions) {
    .Call(`_hmcdm_simDINA`, alphas, itempars, ETA, Test_order, Test_versions)
}

pYit_DINA <- function(ETA_it, Y_it, itempars) {
    .Call(`_hmcdm_pYit_DINA`, ETA_it, Y_it, itempars)
}

sim_resp_rRUM <- function(J, K, Q, rstar, pistar, alpha) {
    .Call(`_hmcdm_sim_resp_rRUM`, J, K, Q, rstar, pistar, alpha)
}

#' @title Simulate rRUM model responses (entire cube)
#' @description Simulate a cube of rRUM responses for all persons on items across all time points
#' @param alphas An N-by-K-by-L \code{array} of attribute patterns of all persons across L time points 
#' @param r_stars_mat A J-by-K \code{cube} of item penalty parameters for missing skills across all item blocks
#' @param pi_stars A Jt-by-L \code{matrix} of item correct response probability with all requisite skills across blocks
#' @param Q_matrix A J-by-K of Q-matrix
#' @param Test_order A N_versions-by-L \code{matrix} indicating which block of items were administered to examinees with specific test version.
#' @param Test_versions A length N \code{vector} of the test version of each examinee
#' @return An \code{array} of rRUM item responses of examinees across all time points
#' @examples
#' N = length(Test_versions)
#' J = nrow(Q_matrix)
#' K = ncol(Q_matrix)
#' L = nrow(Test_order)
#' Jt = J/L
#' Smats <- matrix(runif(J*K,.1,.3),c(J,K))
#' Gmats <- matrix(runif(J*K,.1,.3),c(J,K))
#' r_stars <- Gmats / (1-Smats)
#' pi_stars <- matrix(apply((1-Smats)^Q_matrix, 1, prod), nrow=Jt, ncol=L, byrow=L)
#' Test_versions_sim <- sample(1:5,N,replace = L)
#' tau <- numeric(K)
#'   for(k in 1:K){
#'     tau[k] <- runif(1,.2,.6)
#'   }
#'   R = matrix(0,K,K)
#' # Initial alphas
#' p_mastery <- c(.5,.5,.4,.4)
#' Alphas_0 <- matrix(0,N,K)
#' for(i in 1:N){
#'   for(k in 1:K){
#'     prereqs <- which(R[k,]==1)
#'     if(length(prereqs)==0){
#'       Alphas_0[i,k] <- rbinom(1,1,p_mastery[k])
#'     }
#'     if(length(prereqs)>0){
#'       Alphas_0[i,k] <- prod(Alphas_0[i,prereqs])*rbinom(1,1,p_mastery)
#'     }
#'   }
#' }
#' Alphas <- simulate_alphas_indept(tau,Alphas_0,L,R) 
#' Y_sim = simrRUM(Alphas,r_stars,pi_stars,Q_matrix,Test_order,Test_versions_sim)
#' @export
simrRUM <- function(alphas, r_stars_mat, pi_stars, Q_matrix, Test_order, Test_versions) {
    .Call(`_hmcdm_simrRUM`, alphas, r_stars_mat, pi_stars, Q_matrix, Test_order, Test_versions)
}

pYit_rRUM <- function(alpha_it, Y_it, pi_star_it, r_star_it, Q_it) {
    .Call(`_hmcdm_pYit_rRUM`, alpha_it, Y_it, pi_star_it, r_star_it, Q_it)
}

sim_resp_NIDA <- function(J, K, Q, Svec, Gvec, alpha) {
    .Call(`_hmcdm_sim_resp_NIDA`, J, K, Q, Svec, Gvec, alpha)
}

#' @title Simulate NIDA model responses (entire cube)
#' @description Simulate a cube of NIDA responses for all persons on items across all time points
#' @param alphas An N-by-K-by-L \code{array} of attribute patterns of all persons across L time points 
#' @param Svec A length K \code{vector} of slipping probability in applying mastered skills
#' @param Gvec A length K \code{vector} of guessing probability in applying mastered skills
#' @param Q_matrix A J-by-K Q-matrix
#' @param Test_order A N_versions-by-L \code{matrix} indicating which block of items were administered to examinees with specific test version.
#' @param Test_versions A length N \code{vector} of the test version of each examinee
#' @return An \code{array} of NIDA item responses of examinees across all time points
#' @examples
#' N = length(Test_versions)
#' J = nrow(Q_matrix)
#' K = ncol(Q_matrix)
#' L = nrow(Test_order)
#' Jt = J/L
#' Svec <- runif(K,.1,.3)
#' Gvec <- runif(K,.1,.3)
#' Test_versions_sim <- sample(1:5,N,replace = L)
#' tau <- numeric(K)
#'   for(k in 1:K){
#'     tau[k] <- runif(1,.2,.6)
#'   }
#'   R = matrix(0,K,K)
#' # Initial alphas
#'     p_mastery <- c(.5,.5,.4,.4)
#'     Alphas_0 <- matrix(0,N,K)
#'     for(i in 1:N){
#'       for(k in 1:K){
#'         prereqs <- which(R[k,]==1)
#'         if(length(prereqs)==0){
#'           Alphas_0[i,k] <- rbinom(1,1,p_mastery[k])
#'         }
#'         if(length(prereqs)>0){
#'           Alphas_0[i,k] <- prod(Alphas_0[i,prereqs])*rbinom(1,1,p_mastery)
#'         }
#'       }
#'     }
#'    Alphas <- simulate_alphas_indept(tau,Alphas_0,L,R) 
#' Y_sim = simNIDA(Alphas,Svec,Gvec,Q_matrix,Test_order,Test_versions_sim)
#' @export
simNIDA <- function(alphas, Svec, Gvec, Q_matrix, Test_order, Test_versions) {
    .Call(`_hmcdm_simNIDA`, alphas, Svec, Gvec, Q_matrix, Test_order, Test_versions)
}

pYit_NIDA <- function(alpha_it, Y_it, Svec, Gvec, Q_it) {
    .Call(`_hmcdm_pYit_NIDA`, alpha_it, Y_it, Svec, Gvec, Q_it)
}

J_incidence_cube <- function(Test_order, Qs) {
    .Call(`_hmcdm_J_incidence_cube`, Test_order, Qs)
}

G2vec_efficient <- function(ETA, J_incidence, alphas_i, test_version_i, Test_order, t) {
    .Call(`_hmcdm_G2vec_efficient`, ETA, J_incidence, alphas_i, test_version_i, Test_order, t)
}

#' @title Simulate item response times based on Wang et al.'s (2018) joint model of response times and accuracy in learning
#' @description Simulate a cube of subjects' response times across time points according to a variant of the logNormal model
#' @param alphas An N-by-K-by-T \code{array} of attribute patterns of all persons across T time points 
#' @param RT_itempars A J-by-2-by-T \code{array} of item time discrimination and time intensity parameters across item blocks
#' @param Q_matrix A J-by-K  Q-matrix for the test
#' @param taus A length N \code{vector} of latent speed of each person
#' @param phi A \code{scalar} of slope of increase in fluency over time due to covariates (G)
#' @param ETAs A J-by-2^K \code{matrix} of ideal responses across all item blocks generated with ETAmat function
#' @param G_version An \code{int} of the type of covariate for increased fluency (1: G is dichotomous depending on whether all skills required for
#' current item are mastered; 2: G cumulates practice effect on previous items using mastered skills; 3: G is a time block effect invariant across 
#' subjects with different attribute trajectories)
#' @param Test_order A N_versions-by-T \code{matrix} indicating which block of items were administered to examinees with specific test version.
#' @param Test_versions A length N \code{vector} of the test version of each examinee
#' @return A \code{cube} of response times of subjects on each item across time
#' @examples
#' N = length(Test_versions)
#' J = nrow(Q_matrix)
#' K = ncol(Q_matrix)
#' T = nrow(Test_order)
#' Jt = J/T
#' class_0 <- sample(1:2^K, N, replace = T)
#' Alphas_0 <- matrix(0,N,K)
#' mu_thetatau = c(0,0)
#' Sig_thetatau = rbind(c(1.8^2,.4*.5*1.8),c(.4*.5*1.8,.25))
#' Z = matrix(rnorm(N*2),N,2)
#' thetatau_true = Z%*%chol(Sig_thetatau)
#' thetas_true = thetatau_true[,1]
#' taus_true = thetatau_true[,2]
#' G_version = 3
#' phi_true = 0.8
#' for(i in 1:N){
#'   Alphas_0[i,] <- inv_bijectionvector(K,(class_0[i]-1))
#' }
#' lambdas_true <- c(-2, .4, .055)     
#' Q_examinee <- Q_list(Q_matrix, Test_order, Test_versions)
#' Alphas <- simulate_alphas_HO_joint(lambdas_true,thetas_true,Alphas_0,Q_examinee,T,Jt)
#' RT_itempars_true <- array(NA, dim = c(Jt,2,T))
#' RT_itempars_true[,2,] <- rnorm(Jt*T,3.45,.5)
#' RT_itempars_true[,1,] <- runif(Jt*T,1.5,2)
#' ETAs <- ETAmat(K,J,Q_matrix)
#' L_sim <- sim_RT(Alphas,RT_itempars_true,Q_matrix,taus_true,phi_true,ETAs,
#' G_version,Test_order,Test_versions)
#' @export
sim_RT <- function(alphas, RT_itempars, Q_matrix, taus, phi, ETAs, G_version, Test_order, Test_versions) {
    .Call(`_hmcdm_sim_RT`, alphas, RT_itempars, Q_matrix, taus, phi, ETAs, G_version, Test_order, Test_versions)
}

dLit <- function(G_it, L_it, RT_itempars_it, tau_i, phi) {
    .Call(`_hmcdm_dLit`, G_it, L_it, RT_itempars_it, tau_i, phi)
}

#' @title Generate attribute trajectories under the Higher-Order Hidden Markov DCM
#' @description Based on the initial attribute patterns and learning model parameters, create cube of attribute patterns
#' of all subjects across time. General learning ability is regarded as a fixed effect and has a slope.
#' @param lambdas A length 4 \code{vector} of transition model coefficients. First entry is intercept of the logistic transition
#' model, second entry is the slope of general learning ability, third entry is the slope for number of other mastered skills,
#' fourth entry is the slope for amount of practice.
#' @param thetas A length N \code{vector} of learning abilities of each subject.
#' @param alpha0s An N-by-K \code{matrix} of subjects' initial attribute patterns.
#' @param Q_examinee A length N \code{list} of Jt*K Q matrices across time for each examinee, items are in the order that they are
#' administered to the examinee
#' @param L An \code{int} of number of time points
#' @param Jt An \code{int} of number of items in each block
#' @return An N-by-K-by-L \code{array} of attribute patterns of subjects at each time point.
#' @examples
#' N = length(Test_versions)
#' J = nrow(Q_matrix)
#' K = ncol(Q_matrix)
#' L = nrow(Test_order)
#' Jt = J/L
#' class_0 <- sample(1:2^K, N, replace = L)
#' Alphas_0 <- matrix(0,N,K)
#' thetas_true = rnorm(N)
#' for(i in 1:N){
#'   Alphas_0[i,] <- inv_bijectionvector(K,(class_0[i]-1))
#' }
#' lambdas_true = c(-1, 1.8, .277, .055)
#' Q_examinee <- Q_list(Q_matrix, Test_order, Test_versions)
#' Alphas <- simulate_alphas_HO_sep(lambdas_true,thetas_true,Alphas_0,Q_examinee,L,Jt)
#' @export
simulate_alphas_HO_sep <- function(lambdas, thetas, alpha0s, Q_examinee, L, Jt) {
    .Call(`_hmcdm_simulate_alphas_HO_sep`, lambdas, thetas, alpha0s, Q_examinee, L, Jt)
}

pTran_HO_sep <- function(alpha_prev, alpha_post, lambdas, theta_i, Q_i, Jt, t) {
    .Call(`_hmcdm_pTran_HO_sep`, alpha_prev, alpha_post, lambdas, theta_i, Q_i, Jt, t)
}

#' @title Generate attribute trajectories under the Higher-Order Hidden Markov DCM with latent learning ability as a random effect
#' @description Based on the initial attribute patterns and learning model parameters, create cube of attribute patterns
#' of all subjects across time. General learning ability is regarded as a random intercept.
#' @param lambdas A length 3 \code{vector} of transition model coefficients. First entry is intercept of the logistic transition
#' model, second entry is the slope for number of other mastered skills, third entry is the slope for amount of practice.
#' @param thetas A length N \code{vector} of learning abilities of each subject.
#' @param alpha0s An N-by-K \code{matrix} of subjects' initial attribute patterns.
#' @param Q_examinee A length N \code{list} of Jt*K Q matrices across time for each examinee, items are in the order that they are
#' administered to the examinee
#' @param L An \code{int} of number of time points
#' @param Jt An \code{int} of number of items in each block
#' @return An N-by-K-by-L \code{array} of attribute patterns of subjects at each time point.
#' @examples
#' N = length(Test_versions)
#' J = nrow(Q_matrix)
#' K = ncol(Q_matrix)
#' L = nrow(Test_order)
#' Jt = J/L
#' class_0 <- sample(1:2^K, N, replace = L)
#' Alphas_0 <- matrix(0,N,K)
#' mu_thetatau = c(0,0)
#' Sig_thetatau = rbind(c(1.8^2,.4*.5*1.8),c(.4*.5*1.8,.25))
#' Z = matrix(rnorm(N*2),N,2)
#' thetatau_true = Z%*%chol(Sig_thetatau)
#' thetas_true = thetatau_true[,1]
#' for(i in 1:N){
#'   Alphas_0[i,] <- inv_bijectionvector(K,(class_0[i]-1))
#' }
#' lambdas_true <- c(-2, .4, .055)     
#' Q_examinee <- Q_list(Q_matrix, Test_order, Test_versions)
#' Alphas <- simulate_alphas_HO_joint(lambdas_true,thetas_true,Alphas_0,Q_examinee,L,Jt)
#' @export
simulate_alphas_HO_joint <- function(lambdas, thetas, alpha0s, Q_examinee, L, Jt) {
    .Call(`_hmcdm_simulate_alphas_HO_joint`, lambdas, thetas, alpha0s, Q_examinee, L, Jt)
}

pTran_HO_joint <- function(alpha_prev, alpha_post, lambdas, theta_i, Q_i, Jt, t) {
    .Call(`_hmcdm_pTran_HO_joint`, alpha_prev, alpha_post, lambdas, theta_i, Q_i, Jt, t)
}

#' @title Generate attribute trajectories under the simple independent-attribute learning model
#' @description Based on the initial attribute patterns and probability of transitioning from 0 to 1 on each attribute, 
#' create cube of attribute patterns of all subjects across time. Transitions on different skills are regarded as independent.
#' @param taus A length K \code{vector} of transition probabilities from 0 to 1 on each skill
#' @param alpha0s An N-by-K \code{matrix} of subjects' initial attribute patterns.
#' @param L An \code{int} of number of time points
#' @param R A K-by-K dichotomous reachability \code{matrix} indicating the attribute hierarchies. The k,k'th entry of R is 1 if k' is prereq to k.
#' @return An N-by-K-by-L \code{array} of attribute patterns of subjects at each time point.
#' @examples
#' N = length(Test_versions)
#' J = nrow(Q_matrix)
#' K = ncol(Q_matrix)
#' L = nrow(Test_order)
#' Jt = J/L
#' tau <- numeric(K)
#' for(k in 1:K){
#'   tau[k] <- runif(1,.2,.6)
#' }
#' R = matrix(0,K,K)
#' # Initial alphas
#' p_mastery <- c(.5,.5,.4,.4)
#' Alphas_0 <- matrix(0,N,K)
#' for(i in 1:N){
#'   for(k in 1:K){
#'     prereqs <- which(R[k,]==1)
#'     if(length(prereqs)==0){
#'       Alphas_0[i,k] <- rbinom(1,1,p_mastery[k])
#'     }
#'     if(length(prereqs)>0){
#'       Alphas_0[i,k] <- prod(Alphas_0[i,prereqs])*rbinom(1,1,p_mastery)
#'     }
#'   }
#' }
#' Alphas <- simulate_alphas_indept(tau,Alphas_0,L,R) 
#' @export
simulate_alphas_indept <- function(taus, alpha0s, L, R) {
    .Call(`_hmcdm_simulate_alphas_indept`, taus, alpha0s, L, R)
}

pTran_indept <- function(alpha_prev, alpha_post, taus, R) {
    .Call(`_hmcdm_pTran_indept`, alpha_prev, alpha_post, taus, R)
}

#' @title Generate attribute trajectories under the first order hidden Markov model
#' @description Based on the initial attribute patterns and probability of transitioning between different patterns, 
#' create cube of attribute patterns of all subjects across time. 
#' @param Omega A 2^K-by-2^K \code{matrix} of transition probabilities from row pattern to column pattern
#' @param alpha0s An N-by-K \code{matrix} of subjects' initial attribute patterns.
#' @param L An \code{int} of number of time points
#' @return An N-by-K-by-L \code{array} of attribute patterns of subjects at each time point. 
#' @examples
#' N = length(Test_versions)
#' J = nrow(Q_matrix)
#' K = ncol(Q_matrix)
#' L = nrow(Test_order)
#' Jt = J/L
#' TP <- TPmat(K)
#' Omega_true <- rOmega(TP)
#' class_0 <- sample(1:2^K, N, replace = L)
#' Alphas_0 <- matrix(0,N,K)
#' for(i in 1:N){
#'   Alphas_0[i,] <- inv_bijectionvector(K,(class_0[i]-1))
#' }
#' Alphas <- simulate_alphas_FOHM(Omega_true, Alphas_0,L)
#' @export
simulate_alphas_FOHM <- function(Omega, alpha0s, L) {
    .Call(`_hmcdm_simulate_alphas_FOHM`, Omega, alpha0s, L)
}

rAlpha <- function(Omega, N, L, alpha1) {
    .Call(`_hmcdm_rAlpha`, Omega, N, L, alpha1)
}

#' @title Generate a random transition matrix for the first order hidden Markov model
#' @description Generate a random transition matrix under nondecreasing learning trajectory assumption
#' @param TP A 2^K-by-2^K dichotomous matrix of indicating possible transitions under the monotonicity assumption, created with
#' the TPmat function 
#' @return A 2^K-by-2^K transition matrix, the (i,j)th element indicating the transition probability of transitioning from i-th class to j-th class.
#' @examples
#' K = ncol(Q_matrix)
#' TP = TPmat(K)
#' Omega_sim = rOmega(TP)
#' @export
rOmega <- function(TP) {
    .Call(`_hmcdm_rOmega`, TP)
}

