% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{make_route_grid}
\alias{make_route_grid}
\title{Make lat-long grid for route finding}
\usage{
make_route_grid(
  fat_map,
  name,
  target_km = 800,
  lat_min = -60,
  lat_max = 86,
  long_min = -180,
  long_max = 179.95,
  classify = FALSE
)
}
\arguments{
\item{fat_map}{MULTIPOLYGON map defining land regions}

\item{name}{String assigned to the name slot of the result}

\item{target_km}{Target length. Default 800km
only to avoid accidentally starting heavy compute.
30-50km would be more useful.}

\item{lat_min, lat_max}{Latitude extent of grid}

\item{long_min, long_max}{Longitude extend of grid.
Two allow small grids crossing the 180 boundary, the function
accepts values outside [-180,180), then rounds to within this
range.}

\item{classify}{Whether to classify each link. Defaults to
FALSE only to avoid accidentally starting heavy compute.}
}
\value{
\code{gridLat} object containing points and lattice.
}
\description{
\code{make_route_grid} creates, and optionally classifies, a lat-long route grid
}
\details{
This function creates a \linkS4class{GridLat} object that contains
a set of point on a lat long grid (ie all the points are on
lines of latitude). It also joins these points into a lattice.
Optionally, but required later, it classifies each link as land, sea,
or transition, with reference to a given map (typically including a
coastal buffer).

The definitions are

\itemize{
  \item land: both ends of the link are on land
  \item sea: both ends are on sea, and the link does not intersect the land
  \item transition: otherwise
}

The length of the links will be around \code{target_km} or 50pct longer
for the diagonal links.

For more details see the help vignette:
\code{vignette("Supersonic Routing", package = "himach")}
}
\examples{
NZ_buffer <- sf::st_transform(NZ_buffer30, crs=crs_Pacific)
system.time(
  p_grid <- make_route_grid(NZ_buffer,"NZ lat-long at 300km",
                           target_km = 300, classify = TRUE,
                           lat_min = -49, lat_max = -32,
                           long_min = 162, long_max = 182)
)

}
