% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords_to_position.R
\name{coords_to_position}
\alias{coords_to_position}
\alias{coords_to_position.data.frame}
\alias{coords_to_position.matrix}
\alias{coords_to_position.numeric}
\alias{coords_to_position.double}
\alias{coords_to_position.integer}
\alias{coords_to_position64}
\alias{coords_to_position64.data.frame}
\alias{coords_to_position64.matrix}
\alias{coords_to_position64.numeric}
\alias{coords_to_position64.double}
\alias{coords_to_position64.integer}
\title{Convert Coordinates to Grid Positions}
\usage{
coords_to_position(x, ..., n = 10L, extent = NULL)

\method{coords_to_position}{data.frame}(x, ..., n, extent, coords = c(1, 2), attach = TRUE)

\method{coords_to_position}{matrix}(x, ..., n, extent, coords = c(1, 2), attach = TRUE)

\method{coords_to_position}{numeric}(x, y, ..., n, extent)

\method{coords_to_position}{double}(x, y, ..., n, extent)

\method{coords_to_position}{integer}(x, y, ..., n, extent)

coords_to_position64(x, ..., n = 10L, extent = NULL)

\method{coords_to_position64}{data.frame}(x, ..., n, extent, coords = c(1, 2), attach = TRUE)

\method{coords_to_position64}{matrix}(x, ..., n, extent, coords = c(1, 2), attach = TRUE)

\method{coords_to_position64}{numeric}(x, y, ..., n, extent)

\method{coords_to_position64}{double}(x, y, ..., n, extent)

\method{coords_to_position64}{integer}(x, y, ..., n, extent)
}
\arguments{
\item{x}{One of: Numeric vector, \code{data.frame}, or \code{matrix}.
If a numeric vector, then it corresponds to X coordinates.}

\item{...}{Unused.}

\item{n}{Exponent to the dimensions of the underlying grid. The Hilbert
Curve indices are based on a \verb{2^n x 2^n} grid. This number
must be less than 15 due to the 32-bit implementation of R.}

\item{extent}{Named vector with names \code{xmax}, \code{xmin}, \code{ymax}, \code{ymin}.
Corresponds to the bounding box of the given coordinates.
If \code{extent} is \code{NULL}, then the bounding box is found from the
given coordinates.}

\item{coords}{Column names or indices of a \code{data.frame}/\code{matrix} that
contain the coordinates.}

\item{attach}{If \code{TRUE}, adds the position as new columns to the given
\code{data.frame}/\code{matrix}. This will \emph{replace} the coordinate columns.}

\item{y}{Numeric vector corresponding to Y coordinates.}
}
\value{
A \code{data.frame} containing the positions as \code{integer}
columns \code{x} and \code{y}, or the original object
(\code{data.frame} or \code{matrix}) with the coordinates
replaced with the grid positions. When \code{n} is greater than 15,
the positions are of type \code{bit64::integer64}.
}
\description{
Convert Coordinates to Grid Positions
}
