% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realizedMeasures.R
\name{rMPVar}
\alias{rMPVar}
\title{Realized multipower variation}
\usage{
rMPVar(
  rData,
  m = 2,
  p = 2,
  alignBy = NULL,
  alignPeriod = NULL,
  makeReturns = FALSE,
  ...
)
}
\arguments{
\item{rData}{an \code{xts} or \code{data.table} object containing returns or prices, possibly for multiple assets over multiple days.}

\item{m}{the window size of return blocks. 2 by default.}

\item{p}{the power of the variation. 2 by default.}

\item{alignBy}{character, indicating the time scale in which \code{alignPeriod} is expressed. 
Possible values are: \code{"ticks"}, \code{"secs"}, \code{"seconds"}, \code{"mins"}, \code{"minutes"}, \code{"hours"}}

\item{alignPeriod}{positive numeric, indicating the number of periods to aggregate over. For example, to aggregate
based on a 5-minute frequency, set \code{alignPeriod = 5} and \code{alignBy = "minutes"}.}

\item{makeReturns}{boolean, should be \code{TRUE} when \code{rData} contains prices instead of returns. \code{FALSE} by default.}

\item{...}{used internally, do not change.}
}
\value{
numeric
}
\description{
Calculate the Realized Multipower Variation rMPVar, defined in Andersen et al. (2012).

Assume there are \eqn{N} equispaced returns \eqn{r_{t,i}} in period \eqn{t}, \eqn{i=1, \ldots,N}. Then, the rMPVar is given by
  \deqn{
    \mbox{rMPVar}_{N}(m,p)= d_{m,p} \frac{N^{p/2}}{N-m+1} \sum_{i=1}^{N-m+1}|r_{t,i}|^{p/m} \ldots |r_{t,i+m-1}|^{p/m}
  }

in which

\eqn{d_{m,p} = \mu_{p/m}^{-m}}:

\eqn{m}: the window size of return blocks;

\eqn{p}: the power of the variation;

and \eqn{m} > \eqn{p/2}.
}
\examples{
mpv <- rMPVar(sampleTData[, list(DT, PRICE)], m = 2, p = 3, alignBy = "minutes",
            alignPeriod = 5, makeReturns = TRUE)
mpv
}
\references{
Andersen, T. G., Dobrev, D., and Schaumburg, E. (2012). Jump-robust volatility estimation using nearest neighbor truncation. \emph{Journal of Econometrics}, 169, 75-93.
}
\seealso{
\code{\link{IVar}} for a list of implemented estimators of the integrated variance.
}
\author{
Giang Nguyen, Jonathan Cornelissen, Kris Boudt, and Emil Sjoerup.
}
\keyword{highfrequency}
\keyword{rMPVar}
