% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realizedMeasures.R
\name{rBeta}
\alias{rBeta}
\title{Realized beta}
\usage{
rBeta(
  rData,
  rIndex,
  RCOVestimator = "rCov",
  RVestimator = "RV",
  makeReturns = FALSE
)
}
\arguments{
\item{rData}{a \code{xts} object containing all returns in period t for one asset.}

\item{rIndex}{a \code{xts} object containing return in period t for an index.}

\item{RCOVestimator}{can be chosen among realized covariance estimators: \code{"rCov"}, \code{"rAVGCov"}, \code{"rBPCov"}, \code{"rHYCov"}, \code{"rKernelCov"}, \code{"rOWCov"}, \code{"rRTSCov"}, \code{"rThresholdCov"} and \code{"rTSCov"} \code{"rCov"} by default.}

\item{RVestimator}{can be chosen among realized variance estimators: \code{"RV"}, \code{"rMinRV"} and \code{"rMedRV"}. \code{"RV"} by default. 
In case of missing \code{RVestimator}, \code{RCOVestimator} function applying for \code{rIndex} will be used.}

\item{makeReturns}{boolean, should be \code{TRUE} when \code{rData} contains prices instead of returns. \code{FALSE} by default.}
}
\value{
numeric
}
\description{
Depending on users' choices of estimator (realized covariance (RCOVestimator) and realized variance (RVestimator)), 
the function returns the realized beta, defined as the ratio between both.

The realized beta is given by
\deqn{
\beta_{jm} = \frac {RCOVestimator_{jm}}{RVestimator_{m}}
}

in which

\eqn{RCOVestimator:} Realized covariance of asset j and market index \eqn{m}.

\eqn{RVestimator:} Realized variance of market index \eqn{m}.
}
\details{
Suppose there are \eqn{N} equispaced returns on day \eqn{t} for the asset \eqn{j} and the index \eqn{m}. 
Denote \eqn{r_{(j)i,t}}, \eqn{r_{(m)i,t}} as the \eqn{i}th return on day \eqn{t} for asset \eqn{j} and index \eqn{m} (with \eqn{i=1, \ldots,N}).

By default, the RCov is used and the realized beta coefficient is computed as:
\deqn{
\hat{\beta}_{(jm)t}= \frac{\sum_{i=1}^{N} r_{(j)i,t} r_{(m)i,t}}{\sum_{i=1}^{N} r_{(m)i,t}^2}.
}

Note: The function does not support to calculate betas across multiple days.
}
\examples{
\dontrun{
library("xts")
a <- as.xts(sampleOneMinuteData[as.Date(DT) == "2001-08-04", list(DT, MARKET)])
b <-  as.xts(sampleOneMinuteData[as.Date(DT) == "2001-08-04", list(DT, STOCK)])
rBeta(a, b, RCOVestimator = "rBPCov", RVestimator = "rMinRV", makeReturns = TRUE)
}

}
\references{
Barndorff-Nielsen, O. E. and Shephard, N. (2004). Econometric analysis of realized covariation: high frequency based covariance, regression, and correlation in
financial economics. \emph{Econometrica}, 72, 885-925.
}
\author{
Giang Nguyen, Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup.
}
\keyword{highfrequency}
\keyword{rBeta}
