% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{aggregateTrades}
\alias{aggregateTrades}
\title{Aggregate a data.table or xts object containing trades data}
\usage{
aggregateTrades(
  tData,
  on = "minutes",
  k = 5,
  marketOpen = "09:30:00",
  marketClose = "16:00:00",
  tz = "GMT"
)
}
\arguments{
\item{tData}{data.table or xts object to be aggregated, containing the intraday price series of a stock for possibly multiple days.}

\item{on}{character, indicating the time scale in which "k" is expressed. Possible values are: "secs", "seconds", "mins", "minutes", "hours".}

\item{k}{positive integer, indicating the number of periods to aggregate over. E.g. to aggregate an
object to the 5 minute frequency set k = 5 and on = "minutes".}

\item{marketOpen}{the market opening time, by default: marketOpen = "09:30:00".}

\item{marketClose}{the market closing time, by default: marketClose = "16:00:00".}

\item{tz}{time zone used, by default: tz = "GMT".}
}
\value{
A data.table or xts object containing the aggregated time series.
}
\description{
Function returns new time series as a data.table or xts object where first observation is always the opening price
and subsequent observations are the closing prices over the interval.
}
\details{
The timestamps of the new time series are the closing times and/or days of the intervals. 

The output "PRICE" column is constructed using previous tick aggregation.

The variable "SIZE" is aggregated by taking the sum over each interval.

The variable "VWPRICE" is the aggregated price weighted by volume.

The timestamps of the new time series are the closing times of the intervals. 

In case of previous tick aggregation or on = "seconds"/"minutes"/"hours",
the element of the returned series with e.g. timestamp 09:35:00 contains 
the last observation up to that point, including the value at 09:35:00 itself.
}
\examples{
# aggregate trade data to 5 minute frequency
tDataAggregated <- aggregateTrades(sampleTData, on = "minutes", k = 5)
head(tDataAggregated)
}
\author{
Jonathan Cornelissen, Kris Boudt and Onno Kleen.
}
\keyword{data}
\keyword{manipulation}
