% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-helpers.R
\name{data_to_hierarchical}
\alias{data_to_hierarchical}
\title{Helper to transform data frame for treemap/sunburst highcharts format}
\usage{
data_to_hierarchical(
  data,
  group_vars,
  size_var,
  colors = getOption("highcharter.color_palette")
)
}
\arguments{
\item{data}{data frame containing variables to organize each level of
the treemap.}

\item{group_vars}{Variables to generate treemap levels.}

\item{size_var}{Variable to aggregate.}

\item{colors}{Color to chart every item in the first level.}
}
\description{
Helper to transform data frame for treemap/sunburst highcharts format
}
\examples{

\dontrun{

library(dplyr)
data(gapminder, package = "gapminder")

gapminder_2007 <- gapminder::gapminder \%>\% 
  filter(year  == max(year)) \%>\% 
  mutate(pop_mm = round(pop/1e6))

dout <- data_to_hierarchical(gapminder_2007, c(continent, country), pop_mm)

hchart(dout, type = "sunburst")

hchart(dout, type = "treemap")
}

}
