% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highmaps.R
\name{hcmap}
\alias{hcmap}
\title{Shorcut for create map
Shorcut for create map from \url{https://code.highcharts.com/mapdata/}
collection.}
\usage{
hcmap(map = "custom/world",
  download_map_data = getOption("highcharter.download_map_data"),
  data = NULL, value = NULL, joinBy = NULL, ...)
}
\arguments{
\item{map}{String indicating what map to chart.}

\item{download_map_data}{A logical value whether to download
(add as a depedeny) the map. Default \code{FALSE}.}

\item{data}{Optional data to make a choropleth, in case of use
the joinBy and value are needed.}

\item{value}{A string value with the name of the column to chart.}

\item{joinBy}{What property to join the  \code{map} and \code{df}.
the map.}

\item{...}{Aditional shared arguments for the data series
(\url{http://api.highcharts.com/highcharts#series}).}
}
\description{
Shorcut for create map
Shorcut for create map from \url{https://code.highcharts.com/mapdata/}
collection.
}
\examples{
require(dplyr) 
hcmap(nullColor = "#DADADA")
hcmap(nullColor = "#DADADA", download_map_data = TRUE)

data("USArrests", package = "datasets")
USArrests <- mutate(USArrests, "woe-name" = rownames(USArrests))

hcmap(map = "countries/us/us-all", data = USArrests,
      joinBy = "woe-name", value = "UrbanPop", name = "Urban Population")
      
hcmap(map = "countries/us/us-all", data = USArrests,
      joinBy = "woe-name", value = "UrbanPop", name = "Urban Population",
      download_map_data = TRUE) 
  
}

