% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortcuts.R
\name{hc_add_series_map}
\alias{hc_add_series_map}
\title{Shorcut for create map}
\usage{
hc_add_series_map(hc, map, df, value, joinBy, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{map}{A \code{list} object loaded from a geojson file.}

\item{df}{A \code{data.frame} object with data to chart. Code region and value are
required.}

\item{value}{A string value with the name of the column to chart.}

\item{joinBy}{What property to join the  \code{map} and \code{df}}

\item{...}{Aditional shared arguments for the data series
(\url{http://api.highcharts.com/highcharts#series}).}
}
\description{
This function helps to create higcharts treemaps from \code{treemap} objects
from the package \code{treemap}.
}
\examples{

library("dplyr")
library("viridisLite")

data("USArrests", package = "datasets")
data("usgeojson")

USArrests <- USArrests \%>\% 
  mutate(state = rownames(.))

n <- 4
colstops <- data.frame(q = 0:n/n,
                       c = substring(viridis(n + 1, option = "A"), 0, 7)) \%>\% 
list_parse2()

highchart() \%>\% 
  hc_title(text = "Violent Crime Rates by US State") \%>\% 
  hc_subtitle(text = "Source: USArrests data") \%>\% 
  hc_add_series_map(usgeojson, USArrests, name = "Murder arrests (per 100,000)",
                    value = "Murder", joinBy = c("woename", "state"),
                    dataLabels = list(enabled = TRUE,
                                      format = '{point.properties.postalcode}')) \%>\% 
  hc_colorAxis(stops = colstops) \%>\% 
  hc_legend(valueDecimals = 0, valueSuffix = "\%") \%>\%
  hc_mapNavigation(enabled = TRUE) 

\dontrun{

library("viridisLite")
library("dplyr")
data(unemployment)
data(uscountygeojson)
 
dclass <- data_frame(from = seq(0, 10, by = 2),
                     to = c(seq(2, 10, by = 2), 50),
                     color = substring(viridis(length(from), option = "C"), 0, 7))
 dclass <- list_parse(dclass)
highchart() \%>\% 
  hc_title(text = "US Counties unemployment rates, April 2015") \%>\% 
  hc_add_series_map(uscountygeojson, unemployment,
                    value = "value", joinBy = "code") \%>\%
  hc_colorAxis(dataClasses = dclass) \%>\%
  hc_legend(layout = "vertical", align = "right",
            floating = TRUE, valueDecimals = 0,
            valueSuffix = "\%") \%>\%
  hc_mapNavigation(enabled = TRUE)
  
}
  
}

