% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlhighKap.R
\name{mlhighKap}
\alias{mlhighKap}
\title{mlhighKap}
\usage{
mlhighKap(cols, idSurv, idEvent, per = 20, fold = 3, data)
}
\arguments{
\item{cols}{A numeric vector of column numbers indicating the features for which the log Loss functions are to be computed}

\item{idSurv}{The name of the survival time variable}

\item{idEvent}{The name of the survival event variable}

\item{per}{Percentage of features to be selected, default value 20}

\item{fold}{An integer denoting number of folds in cross validation, default value 3}

\item{data}{A data frame that contains the survival and covariate information for the subjects}
}
\value{
A dataframe containing desired number of features based on minimum log Loss function
}
\description{
This function extracts desired number of features based on minimum log-Loss function using Kaplan Meier model as learner
method on a high dimensional survival data.
}
\details{
Performs feature selection using Kaplan Meier method

Using the Kaplan Meier method on the given survival data, this function selects the most significant feature based on a performance measure. The performance measure is considered as logarithmic loss function. It is defined as,
\deqn{L(f,t)=-log(f(t))}. The features with minimum log-loss function are extracted.
}
\examples{
\donttest{
data(hnscc)
mlhighKap(cols=c(6:15), idSurv="OS", idEvent="Death", per=20, fold = 3, data=hnscc)
}
}
\seealso{
mlhighCox
}
\author{
Atanu Bhattacharjee, Gajendra K. Vishwakarma & Souvik Banerjee
}
